import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { forwardRef } from "react";
import { clsx } from "clsx";
import { markdown } from "../markdown.js";
/* empty css             */
const MarkdownContent = forwardRef((t0, ref) => {
  const $ = c(18);
  let children;
  let onlyShowFirstChild;
  let props;
  let type;
  if ($[0] !== t0) {
    ({
      children,
      onlyShowFirstChild,
      type,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = children;
    $[2] = onlyShowFirstChild;
    $[3] = props;
    $[4] = type;
  } else {
    children = $[1];
    onlyShowFirstChild = $[2];
    props = $[3];
    type = $[4];
  }
  const t1 = `graphiql-markdown-${type}`;
  const t2 = onlyShowFirstChild && "graphiql-markdown-preview";
  let t3;
  if ($[5] !== props.className || $[6] !== t1 || $[7] !== t2) {
    t3 = clsx(t1, t2, props.className);
    $[5] = props.className;
    $[6] = t1;
    $[7] = t2;
    $[8] = t3;
  } else {
    t3 = $[8];
  }
  let t4;
  if ($[9] !== children) {
    t4 = markdown.render(children);
    $[9] = children;
    $[10] = t4;
  } else {
    t4 = $[10];
  }
  let t5;
  if ($[11] !== t4) {
    t5 = {
      __html: t4
    };
    $[11] = t4;
    $[12] = t5;
  } else {
    t5 = $[12];
  }
  let t6;
  if ($[13] !== props || $[14] !== ref || $[15] !== t3 || $[16] !== t5) {
    t6 = /* @__PURE__ */ jsx("div", { ...props, ref, className: t3, dangerouslySetInnerHTML: t5 });
    $[13] = props;
    $[14] = ref;
    $[15] = t3;
    $[16] = t5;
    $[17] = t6;
  } else {
    t6 = $[17];
  }
  return t6;
});
MarkdownContent.displayName = "MarkdownContent";
export {
  MarkdownContent
};
//# sourceMappingURL=markdown.js.map
