import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { formatResult, isObservable, formatError, isAsyncIterable } from "@graphiql/toolkit";
import { print } from "graphql";
import { getFragmentDependenciesForAST } from "graphql-language-service";
import { useState, useRef } from "react";
import setValue from "set-value";
import getValue from "get-value";
import { createNullableContext, createContextHook } from "./utility/context.js";
import { useEditorContext } from "./editor/context.js";
import { useAutoCompleteLeafs } from "./editor/hooks.js";
const ExecutionContext = createNullableContext("ExecutionContext");
function ExecutionContextProvider(t0) {
  const $ = c(26);
  const {
    fetcher,
    getDefaultFieldNames,
    children,
    operationName
  } = t0;
  if (typeof fetcher !== "function") {
    throw new TypeError("The `ExecutionContextProvider` component requires a `fetcher` function to be passed as prop.");
  }
  let t1;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true,
      caller: ExecutionContextProvider
    };
    $[0] = t1;
  } else {
    t1 = $[0];
  }
  const {
    externalFragments,
    headerEditor,
    queryEditor,
    responseEditor,
    variableEditor,
    updateActiveTabValues
  } = useEditorContext(t1);
  let t2;
  if ($[1] !== getDefaultFieldNames) {
    t2 = {
      getDefaultFieldNames,
      caller: ExecutionContextProvider
    };
    $[1] = getDefaultFieldNames;
    $[2] = t2;
  } else {
    t2 = $[2];
  }
  const autoCompleteLeafs = useAutoCompleteLeafs(t2);
  const [isFetching, setIsFetching] = useState(false);
  const [subscription, setSubscription] = useState(null);
  const queryIdRef = useRef(0);
  let t3;
  if ($[3] !== subscription) {
    t3 = () => {
      subscription == null ? void 0 : subscription.unsubscribe();
      setIsFetching(false);
      setSubscription(null);
    };
    $[3] = subscription;
    $[4] = t3;
  } else {
    t3 = $[4];
  }
  const stop = t3;
  let t4;
  if ($[5] !== autoCompleteLeafs || $[6] !== externalFragments || $[7] !== fetcher || $[8] !== headerEditor || $[9] !== operationName || $[10] !== queryEditor || $[11] !== responseEditor || $[12] !== stop || $[13] !== subscription || $[14] !== updateActiveTabValues || $[15] !== variableEditor) {
    t4 = async () => {
      if (!queryEditor || !responseEditor) {
        return;
      }
      if (subscription) {
        stop();
        return;
      }
      const setResponse = (value) => {
        responseEditor.setValue(value);
        updateActiveTabValues({
          response: value
        });
      };
      queryIdRef.current = queryIdRef.current + 1;
      const queryId = queryIdRef.current;
      let query = autoCompleteLeafs() || queryEditor.getValue();
      const variablesString = variableEditor == null ? void 0 : variableEditor.getValue();
      let variables;
      try {
        variables = tryParseJsonObject({
          json: variablesString,
          errorMessageParse: "Variables are invalid JSON",
          errorMessageType: "Variables are not a JSON object."
        });
      } catch (t52) {
        const error = t52;
        setResponse(error instanceof Error ? error.message : `${error}`);
        return;
      }
      const headersString = headerEditor == null ? void 0 : headerEditor.getValue();
      let headers;
      try {
        headers = tryParseJsonObject({
          json: headersString,
          errorMessageParse: "Headers are invalid JSON",
          errorMessageType: "Headers are not a JSON object."
        });
      } catch (t62) {
        const error_0 = t62;
        setResponse(error_0 instanceof Error ? error_0.message : `${error_0}`);
        return;
      }
      if (externalFragments) {
        const fragmentDependencies = queryEditor.documentAST ? getFragmentDependenciesForAST(queryEditor.documentAST, externalFragments) : [];
        if (fragmentDependencies.length > 0) {
          query = query + ("\n" + fragmentDependencies.map(_temp).join("\n"));
        }
      }
      setResponse("");
      setIsFetching(true);
      const opName = operationName ?? queryEditor.operationName ?? void 0;
      const _headers = headers ?? void 0;
      const documentAST = queryEditor.documentAST ?? void 0;
      try {
        const fullResponse = {};
        const handleResponse = (result) => {
          if (queryId !== queryIdRef.current) {
            return;
          }
          let maybeMultipart = Array.isArray(result) ? result : false;
          if (!maybeMultipart && typeof result === "object" && result !== null && "hasNext" in result) {
            maybeMultipart = [result];
          }
          if (maybeMultipart) {
            for (const part of maybeMultipart) {
              mergeIncrementalResult(fullResponse, part);
            }
            setIsFetching(false);
            setResponse(formatResult(fullResponse));
          } else {
            const response = formatResult(result);
            setIsFetching(false);
            setResponse(response);
          }
        };
        const fetch = fetcher({
          query,
          variables,
          operationName: opName
        }, {
          headers: _headers,
          documentAST
        });
        const value_0 = await fetch;
        if (isObservable(value_0)) {
          setSubscription(value_0.subscribe({
            next(result_0) {
              handleResponse(result_0);
            },
            error(error_2) {
              setIsFetching(false);
              if (error_2) {
                setResponse(formatError(error_2));
              }
              setSubscription(null);
            },
            complete() {
              setIsFetching(false);
              setSubscription(null);
            }
          }));
        } else {
          if (isAsyncIterable(value_0)) {
            setSubscription({
              unsubscribe: () => {
                var _a, _b;
                return (_b = (_a = value_0[Symbol.asyncIterator]()).return) == null ? void 0 : _b.call(_a);
              }
            });
            await handleAsyncResults(handleResponse, value_0);
            setIsFetching(false);
            setSubscription(null);
          } else {
            handleResponse(value_0);
          }
        }
      } catch (t72) {
        const error_1 = t72;
        setIsFetching(false);
        setResponse(formatError(error_1));
        setSubscription(null);
      }
    };
    $[5] = autoCompleteLeafs;
    $[6] = externalFragments;
    $[7] = fetcher;
    $[8] = headerEditor;
    $[9] = operationName;
    $[10] = queryEditor;
    $[11] = responseEditor;
    $[12] = stop;
    $[13] = subscription;
    $[14] = updateActiveTabValues;
    $[15] = variableEditor;
    $[16] = t4;
  } else {
    t4 = $[16];
  }
  const run = t4;
  const t5 = Boolean(subscription);
  const t6 = operationName ?? null;
  let t7;
  if ($[17] !== isFetching || $[18] !== run || $[19] !== stop || $[20] !== t5 || $[21] !== t6) {
    t7 = {
      isFetching,
      isSubscribed: t5,
      operationName: t6,
      run,
      stop
    };
    $[17] = isFetching;
    $[18] = run;
    $[19] = stop;
    $[20] = t5;
    $[21] = t6;
    $[22] = t7;
  } else {
    t7 = $[22];
  }
  const value_1 = t7;
  let t8;
  if ($[23] !== children || $[24] !== value_1) {
    t8 = /* @__PURE__ */ jsx(ExecutionContext.Provider, { value: value_1, children });
    $[23] = children;
    $[24] = value_1;
    $[25] = t8;
  } else {
    t8 = $[25];
  }
  return t8;
}
function _temp(node) {
  return print(node);
}
async function handleAsyncResults(onResponse, value) {
  for await (const result of value) {
    onResponse(result);
  }
}
const useExecutionContext = createContextHook(ExecutionContext);
function tryParseJsonObject({
  json,
  errorMessageParse,
  errorMessageType
}) {
  let parsed;
  try {
    parsed = json && json.trim() !== "" ? JSON.parse(json) : void 0;
  } catch (error) {
    throw new Error(`${errorMessageParse}: ${error instanceof Error ? error.message : error}.`);
  }
  const isObject = typeof parsed === "object" && parsed !== null && !Array.isArray(parsed);
  if (parsed !== void 0 && !isObject) {
    throw new Error(errorMessageType);
  }
  return parsed;
}
const pathsMap = /* @__PURE__ */ new WeakMap();
function mergeIncrementalResult(executionResult, incrementalResult) {
  var _a, _b, _c;
  let path = ["data", ...incrementalResult.path ?? []];
  for (const result of [executionResult, incrementalResult]) {
    if (result.pending) {
      let paths = pathsMap.get(executionResult);
      if (paths === void 0) {
        paths = /* @__PURE__ */ new Map();
        pathsMap.set(executionResult, paths);
      }
      for (const {
        id,
        path: pendingPath
      } of result.pending) {
        paths.set(id, ["data", ...pendingPath]);
      }
    }
  }
  const {
    items
  } = incrementalResult;
  if (items) {
    const {
      id
    } = incrementalResult;
    if (id) {
      path = (_a = pathsMap.get(executionResult)) == null ? void 0 : _a.get(id);
      if (path === void 0) {
        throw new Error("Invalid incremental delivery format.");
      }
      const list = getValue(executionResult, path.join("."));
      list.push(...items);
    } else {
      path = ["data", ...incrementalResult.path ?? []];
      for (const item of items) {
        setValue(executionResult, path.join("."), item);
        path[path.length - 1]++;
      }
    }
  }
  const {
    data
  } = incrementalResult;
  if (data) {
    const {
      id
    } = incrementalResult;
    if (id) {
      path = (_b = pathsMap.get(executionResult)) == null ? void 0 : _b.get(id);
      if (path === void 0) {
        throw new Error("Invalid incremental delivery format.");
      }
      const {
        subPath
      } = incrementalResult;
      if (subPath !== void 0) {
        path = [...path, ...subPath];
      }
    }
    setValue(executionResult, path.join("."), data, {
      merge: true
    });
  }
  if (incrementalResult.errors) {
    executionResult.errors || (executionResult.errors = []);
    executionResult.errors.push(...incrementalResult.errors);
  }
  if (incrementalResult.extensions) {
    setValue(executionResult, "extensions", incrementalResult.extensions, {
      merge: true
    });
  }
  if (incrementalResult.incremental) {
    for (const incrementalSubResult of incrementalResult.incremental) {
      mergeIncrementalResult(executionResult, incrementalSubResult);
    }
  }
  if (incrementalResult.completed) {
    for (const {
      id,
      errors
    } of incrementalResult.completed) {
      (_c = pathsMap.get(executionResult)) == null ? void 0 : _c.delete(id);
      if (errors) {
        executionResult.errors || (executionResult.errors = []);
        executionResult.errors.push(...errors);
      }
    }
  }
}
export {
  ExecutionContext,
  ExecutionContextProvider,
  useExecutionContext
};
//# sourceMappingURL=execution.js.map
