import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { useState, useEffect } from "react";
import { useStorageContext } from "./storage.js";
import { createNullableContext, createContextHook } from "./utility/context.js";
const PluginContext = createNullableContext("PluginContext");
const PluginContextProvider = (t0) => {
  const $ = c(24);
  const {
    onTogglePluginVisibility,
    children,
    visiblePlugin,
    plugins: $plugins,
    referencePlugin
  } = t0;
  const storage = useStorageContext();
  let t1;
  let pluginList;
  if ($[0] !== $plugins) {
    pluginList = [];
    const pluginTitles = {};
    for (const plugin of $plugins || []) {
      if (typeof plugin.title !== "string" || !plugin.title) {
        throw new Error("All GraphiQL plugins must have a unique title");
      }
      if (pluginTitles[plugin.title]) {
        throw new Error(`All GraphiQL plugins must have a unique title, found two plugins with the title '${plugin.title}'`);
      } else {
        pluginList.push(plugin);
        pluginTitles[plugin.title] = true;
      }
    }
    $[0] = $plugins;
    $[1] = pluginList;
  } else {
    pluginList = $[1];
  }
  t1 = pluginList;
  const plugins = t1;
  let t2;
  if ($[2] !== plugins || $[3] !== storage || $[4] !== visiblePlugin) {
    t2 = () => {
      const storedValue = storage == null ? void 0 : storage.get(STORAGE_KEY);
      const pluginForStoredValue = plugins.find((plugin_0) => plugin_0.title === storedValue);
      if (pluginForStoredValue) {
        return pluginForStoredValue;
      }
      if (storedValue) {
        storage == null ? void 0 : storage.set(STORAGE_KEY, "");
      }
      if (!visiblePlugin) {
        return null;
      }
      return plugins.find((plugin_1) => (typeof visiblePlugin === "string" ? plugin_1.title : plugin_1) === visiblePlugin) || null;
    };
    $[2] = plugins;
    $[3] = storage;
    $[4] = visiblePlugin;
    $[5] = t2;
  } else {
    t2 = $[5];
  }
  const [$visiblePlugin, internalSetVisiblePlugin] = useState(t2);
  let t3;
  if ($[6] !== onTogglePluginVisibility || $[7] !== plugins) {
    t3 = (plugin_2) => {
      const newVisiblePlugin = plugin_2 ? plugins.find((p) => (typeof plugin_2 === "string" ? p.title : p) === plugin_2) || null : null;
      internalSetVisiblePlugin((current) => {
        if (newVisiblePlugin === current) {
          return current;
        }
        onTogglePluginVisibility == null ? void 0 : onTogglePluginVisibility(newVisiblePlugin);
        return newVisiblePlugin;
      });
    };
    $[6] = onTogglePluginVisibility;
    $[7] = plugins;
    $[8] = t3;
  } else {
    t3 = $[8];
  }
  const setVisiblePlugin = t3;
  let t4;
  if ($[9] !== setVisiblePlugin || $[10] !== visiblePlugin) {
    t4 = () => {
      if (visiblePlugin) {
        setVisiblePlugin(visiblePlugin);
      }
    };
    $[9] = setVisiblePlugin;
    $[10] = visiblePlugin;
    $[11] = t4;
  } else {
    t4 = $[11];
  }
  let t5;
  if ($[12] !== plugins || $[13] !== setVisiblePlugin || $[14] !== visiblePlugin) {
    t5 = [plugins, visiblePlugin, setVisiblePlugin];
    $[12] = plugins;
    $[13] = setVisiblePlugin;
    $[14] = visiblePlugin;
    $[15] = t5;
  } else {
    t5 = $[15];
  }
  useEffect(t4, t5);
  let t6;
  if ($[16] !== $visiblePlugin || $[17] !== plugins || $[18] !== referencePlugin || $[19] !== setVisiblePlugin) {
    t6 = {
      plugins,
      setVisiblePlugin,
      visiblePlugin: $visiblePlugin,
      referencePlugin
    };
    $[16] = $visiblePlugin;
    $[17] = plugins;
    $[18] = referencePlugin;
    $[19] = setVisiblePlugin;
    $[20] = t6;
  } else {
    t6 = $[20];
  }
  const value = t6;
  let t7;
  if ($[21] !== children || $[22] !== value) {
    t7 = /* @__PURE__ */ jsx(PluginContext.Provider, { value, children });
    $[21] = children;
    $[22] = value;
    $[23] = t7;
  } else {
    t7 = $[23];
  }
  return t7;
};
const usePluginContext = createContextHook(PluginContext);
const STORAGE_KEY = "visiblePlugin";
export {
  PluginContext,
  PluginContextProvider,
  usePluginContext
};
//# sourceMappingURL=plugin.js.map
