import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { ExecutionContextProvider } from "./execution.js";
import { PluginContextProvider } from "./plugin.js";
import { SchemaContextProvider } from "./schema.js";
import { StorageContextProvider } from "./storage.js";
import { EditorContextProvider } from "./editor/context.js";
const GraphiQLProvider = (t0) => {
  const $ = c(45);
  const {
    children,
    dangerouslyAssumeSchemaIsValid,
    defaultQuery,
    defaultHeaders,
    defaultTabs,
    externalFragments,
    fetcher,
    getDefaultFieldNames,
    headers,
    inputValueDeprecation,
    introspectionQueryName,
    onEditOperationName,
    onSchemaChange,
    onTabChange,
    onTogglePluginVisibility,
    operationName,
    plugins,
    referencePlugin,
    query,
    response,
    schema,
    schemaDescription,
    shouldPersistHeaders,
    storage,
    validationRules,
    variables,
    visiblePlugin
  } = t0;
  let t1;
  if ($[0] !== defaultHeaders || $[1] !== defaultQuery || $[2] !== defaultTabs || $[3] !== externalFragments || $[4] !== headers || $[5] !== onEditOperationName || $[6] !== onTabChange || $[7] !== query || $[8] !== response || $[9] !== shouldPersistHeaders || $[10] !== validationRules || $[11] !== variables) {
    t1 = {
      defaultQuery,
      defaultHeaders,
      defaultTabs,
      externalFragments,
      headers,
      onEditOperationName,
      onTabChange,
      query,
      response,
      shouldPersistHeaders,
      validationRules,
      variables
    };
    $[0] = defaultHeaders;
    $[1] = defaultQuery;
    $[2] = defaultTabs;
    $[3] = externalFragments;
    $[4] = headers;
    $[5] = onEditOperationName;
    $[6] = onTabChange;
    $[7] = query;
    $[8] = response;
    $[9] = shouldPersistHeaders;
    $[10] = validationRules;
    $[11] = variables;
    $[12] = t1;
  } else {
    t1 = $[12];
  }
  const editorContextProps = t1;
  let t2;
  if ($[13] !== dangerouslyAssumeSchemaIsValid || $[14] !== fetcher || $[15] !== inputValueDeprecation || $[16] !== introspectionQueryName || $[17] !== onSchemaChange || $[18] !== schema || $[19] !== schemaDescription) {
    t2 = {
      dangerouslyAssumeSchemaIsValid,
      fetcher,
      inputValueDeprecation,
      introspectionQueryName,
      onSchemaChange,
      schema,
      schemaDescription
    };
    $[13] = dangerouslyAssumeSchemaIsValid;
    $[14] = fetcher;
    $[15] = inputValueDeprecation;
    $[16] = introspectionQueryName;
    $[17] = onSchemaChange;
    $[18] = schema;
    $[19] = schemaDescription;
    $[20] = t2;
  } else {
    t2 = $[20];
  }
  const schemaContextProps = t2;
  let t3;
  if ($[21] !== fetcher || $[22] !== getDefaultFieldNames || $[23] !== operationName) {
    t3 = {
      getDefaultFieldNames,
      fetcher,
      operationName
    };
    $[21] = fetcher;
    $[22] = getDefaultFieldNames;
    $[23] = operationName;
    $[24] = t3;
  } else {
    t3 = $[24];
  }
  const executionContextProps = t3;
  let t4;
  if ($[25] !== onTogglePluginVisibility || $[26] !== plugins || $[27] !== referencePlugin || $[28] !== visiblePlugin) {
    t4 = {
      onTogglePluginVisibility,
      plugins,
      visiblePlugin,
      referencePlugin
    };
    $[25] = onTogglePluginVisibility;
    $[26] = plugins;
    $[27] = referencePlugin;
    $[28] = visiblePlugin;
    $[29] = t4;
  } else {
    t4 = $[29];
  }
  const pluginContextProps = t4;
  let t5;
  if ($[30] !== children || $[31] !== pluginContextProps) {
    t5 = /* @__PURE__ */ jsx(PluginContextProvider, { ...pluginContextProps, children });
    $[30] = children;
    $[31] = pluginContextProps;
    $[32] = t5;
  } else {
    t5 = $[32];
  }
  let t6;
  if ($[33] !== executionContextProps || $[34] !== t5) {
    t6 = /* @__PURE__ */ jsx(ExecutionContextProvider, { ...executionContextProps, children: t5 });
    $[33] = executionContextProps;
    $[34] = t5;
    $[35] = t6;
  } else {
    t6 = $[35];
  }
  let t7;
  if ($[36] !== schemaContextProps || $[37] !== t6) {
    t7 = /* @__PURE__ */ jsx(SchemaContextProvider, { ...schemaContextProps, children: t6 });
    $[36] = schemaContextProps;
    $[37] = t6;
    $[38] = t7;
  } else {
    t7 = $[38];
  }
  let t8;
  if ($[39] !== editorContextProps || $[40] !== t7) {
    t8 = /* @__PURE__ */ jsx(EditorContextProvider, { ...editorContextProps, children: t7 });
    $[39] = editorContextProps;
    $[40] = t7;
    $[41] = t8;
  } else {
    t8 = $[41];
  }
  let t9;
  if ($[42] !== storage || $[43] !== t8) {
    t9 = /* @__PURE__ */ jsx(StorageContextProvider, { storage, children: t8 });
    $[42] = storage;
    $[43] = t8;
    $[44] = t9;
  } else {
    t9 = $[44];
  }
  return t9;
};
export {
  GraphiQLProvider
};
//# sourceMappingURL=provider.js.map
