import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { formatError, fetcherReturnToPromise, isPromise, formatResult } from "@graphiql/toolkit";
import { validateSchema, getIntrospectionQuery, isSchema, buildClientSchema } from "graphql";
import { useState, useRef, useEffect } from "react";
import { createNullableContext, createContextHook } from "./utility/context.js";
import { useEditorContext } from "./editor/context.js";
const SchemaContext = createNullableContext("SchemaContext");
const SchemaContextProvider = (t0) => {
  const $ = c(41);
  let children;
  let dangerouslyAssumeSchemaIsValid;
  let fetcher;
  let onSchemaChange;
  let props;
  if ($[0] !== t0) {
    ({
      fetcher,
      onSchemaChange,
      dangerouslyAssumeSchemaIsValid,
      children,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = children;
    $[2] = dangerouslyAssumeSchemaIsValid;
    $[3] = fetcher;
    $[4] = onSchemaChange;
    $[5] = props;
  } else {
    children = $[1];
    dangerouslyAssumeSchemaIsValid = $[2];
    fetcher = $[3];
    onSchemaChange = $[4];
    props = $[5];
  }
  if (!fetcher) {
    throw new TypeError("The `SchemaContextProvider` component requires a `fetcher` function to be passed as prop.");
  }
  let t1;
  if ($[6] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      nonNull: true,
      caller: SchemaContextProvider
    };
    $[6] = t1;
  } else {
    t1 = $[6];
  }
  const {
    initialHeaders,
    headerEditor
  } = useEditorContext(t1);
  const [schema, setSchema] = useState();
  const [isFetching, setIsFetching] = useState(false);
  const [fetchError, setFetchError] = useState(null);
  const [schemaReference, setSchemaReference] = useState(null);
  const counterRef = useRef(0);
  let t2;
  let t3;
  if ($[7] !== props.schema) {
    t2 = () => {
      setSchema(isSchema(props.schema) || props.schema == null ? props.schema : void 0);
      counterRef.current = counterRef.current + 1;
    };
    t3 = [props.schema];
    $[7] = props.schema;
    $[8] = t2;
    $[9] = t3;
  } else {
    t2 = $[8];
    t3 = $[9];
  }
  useEffect(t2, t3);
  const headersRef = useRef(initialHeaders);
  let t4;
  if ($[10] !== headerEditor) {
    t4 = () => {
      if (headerEditor) {
        headersRef.current = headerEditor.getValue();
      }
    };
    $[10] = headerEditor;
    $[11] = t4;
  } else {
    t4 = $[11];
  }
  useEffect(t4);
  let t5;
  if ($[12] !== props.inputValueDeprecation || $[13] !== props.introspectionQueryName || $[14] !== props.schemaDescription) {
    t5 = {
      inputValueDeprecation: props.inputValueDeprecation,
      introspectionQueryName: props.introspectionQueryName,
      schemaDescription: props.schemaDescription
    };
    $[12] = props.inputValueDeprecation;
    $[13] = props.introspectionQueryName;
    $[14] = props.schemaDescription;
    $[15] = t5;
  } else {
    t5 = $[15];
  }
  const {
    introspectionQuery,
    introspectionQueryName,
    introspectionQuerySansSubscriptions
  } = useIntrospectionQuery(t5);
  let t6;
  if ($[16] !== fetcher || $[17] !== introspectionQuery || $[18] !== introspectionQueryName || $[19] !== introspectionQuerySansSubscriptions || $[20] !== onSchemaChange || $[21] !== props.schema) {
    t6 = () => {
      if (isSchema(props.schema) || props.schema === null) {
        return;
      }
      const counter = counterRef.current = counterRef.current + 1;
      const maybeIntrospectionData = props.schema;
      const fetchIntrospectionData = async function fetchIntrospectionData2() {
        if (maybeIntrospectionData) {
          return maybeIntrospectionData;
        }
        const parsedHeaders = parseHeaderString(headersRef.current);
        if (!parsedHeaders.isValidJSON) {
          setFetchError("Introspection failed as headers are invalid.");
          return;
        }
        const fetcherOpts = parsedHeaders.headers ? {
          headers: parsedHeaders.headers
        } : {};
        const fetch = fetcherReturnToPromise(fetcher({
          query: introspectionQuery,
          operationName: introspectionQueryName
        }, fetcherOpts));
        if (!isPromise(fetch)) {
          setFetchError("Fetcher did not return a Promise for introspection.");
          return;
        }
        setIsFetching(true);
        setFetchError(null);
        let result = await fetch;
        if (typeof result !== "object" || result === null || !("data" in result)) {
          const fetch2 = fetcherReturnToPromise(fetcher({
            query: introspectionQuerySansSubscriptions,
            operationName: introspectionQueryName
          }, fetcherOpts));
          if (!isPromise(fetch2)) {
            throw new Error("Fetcher did not return a Promise for introspection.");
          }
          result = await fetch2;
        }
        setIsFetching(false);
        if ((result == null ? void 0 : result.data) && "__schema" in result.data) {
          return result.data;
        }
        const responseString = typeof result === "string" ? result : formatResult(result);
        setFetchError(responseString);
      };
      fetchIntrospectionData().then((introspectionData) => {
        if (counter !== counterRef.current || !introspectionData) {
          return;
        }
        try {
          const newSchema = buildClientSchema(introspectionData);
          setSchema(newSchema);
          if (onSchemaChange) {
            onSchemaChange(newSchema);
          }
        } catch (t72) {
          const error = t72;
          setFetchError(formatError(error));
        }
      }).catch((error_0) => {
        if (counter !== counterRef.current) {
          return;
        }
        setFetchError(formatError(error_0));
        setIsFetching(false);
      });
    };
    $[16] = fetcher;
    $[17] = introspectionQuery;
    $[18] = introspectionQueryName;
    $[19] = introspectionQuerySansSubscriptions;
    $[20] = onSchemaChange;
    $[21] = props.schema;
    $[22] = t6;
  } else {
    t6 = $[22];
  }
  const introspect = t6;
  let t7;
  let t8;
  if ($[23] !== introspect) {
    t7 = () => {
      introspect();
    };
    t8 = [introspect];
    $[23] = introspect;
    $[24] = t7;
    $[25] = t8;
  } else {
    t7 = $[24];
    t8 = $[25];
  }
  useEffect(t7, t8);
  let t9;
  if ($[26] !== introspect) {
    t9 = () => {
      const triggerIntrospection = function triggerIntrospection2(event) {
        if (event.ctrlKey && event.key === "R") {
          introspect();
        }
      };
      window.addEventListener("keydown", triggerIntrospection);
      return () => {
        window.removeEventListener("keydown", triggerIntrospection);
      };
    };
    $[26] = introspect;
    $[27] = t9;
  } else {
    t9 = $[27];
  }
  useEffect(t9);
  let t10;
  if ($[28] !== dangerouslyAssumeSchemaIsValid || $[29] !== schema) {
    t10 = !schema || dangerouslyAssumeSchemaIsValid ? [] : validateSchema(schema);
    $[28] = dangerouslyAssumeSchemaIsValid;
    $[29] = schema;
    $[30] = t10;
  } else {
    t10 = $[30];
  }
  const validationErrors = t10;
  let t11;
  if ($[31] !== fetchError || $[32] !== introspect || $[33] !== isFetching || $[34] !== schema || $[35] !== schemaReference || $[36] !== validationErrors) {
    t11 = {
      fetchError,
      introspect,
      isFetching,
      schema,
      validationErrors,
      schemaReference,
      setSchemaReference
    };
    $[31] = fetchError;
    $[32] = introspect;
    $[33] = isFetching;
    $[34] = schema;
    $[35] = schemaReference;
    $[36] = validationErrors;
    $[37] = t11;
  } else {
    t11 = $[37];
  }
  const value = t11;
  let t12;
  if ($[38] !== children || $[39] !== value) {
    t12 = /* @__PURE__ */ jsx(SchemaContext.Provider, { value, children });
    $[38] = children;
    $[39] = value;
    $[40] = t12;
  } else {
    t12 = $[40];
  }
  return t12;
};
const useSchemaContext = createContextHook(SchemaContext);
function useIntrospectionQuery({
  inputValueDeprecation,
  introspectionQueryName,
  schemaDescription
}) {
  const queryName = introspectionQueryName || "IntrospectionQuery";
  let query = getIntrospectionQuery({
    inputValueDeprecation,
    schemaDescription
  });
  if (introspectionQueryName) {
    query = query.replace("query IntrospectionQuery", `query ${queryName}`);
  }
  const querySansSubscriptions = query.replace("subscriptionType { name }", "");
  return {
    introspectionQueryName: queryName,
    introspectionQuery: query,
    introspectionQuerySansSubscriptions: querySansSubscriptions
  };
}
function parseHeaderString(headersString) {
  let headers = null;
  let isValidJSON = true;
  try {
    if (headersString) {
      headers = JSON.parse(headersString);
    }
  } catch {
    isValidJSON = false;
  }
  return {
    headers,
    isValidJSON
  };
}
export {
  SchemaContext,
  SchemaContextProvider,
  useSchemaContext
};
//# sourceMappingURL=schema.js.map
