import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { StorageAPI } from "@graphiql/toolkit";
import { useRef, useState, useEffect } from "react";
import { createNullableContext, createContextHook } from "./utility/context.js";
const StorageContext = createNullableContext("StorageContext");
function StorageContextProvider(props) {
  const $ = c(8);
  const isInitialRender = useRef(true);
  let t0;
  if ($[0] !== props.storage) {
    t0 = () => new StorageAPI(props.storage);
    $[0] = props.storage;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  const [storage, setStorage] = useState(t0);
  let t1;
  let t2;
  if ($[2] !== props.storage) {
    t1 = () => {
      if (isInitialRender.current) {
        isInitialRender.current = false;
      } else {
        setStorage(new StorageAPI(props.storage));
      }
    };
    t2 = [props.storage];
    $[2] = props.storage;
    $[3] = t1;
    $[4] = t2;
  } else {
    t1 = $[3];
    t2 = $[4];
  }
  useEffect(t1, t2);
  let t3;
  if ($[5] !== props.children || $[6] !== storage) {
    t3 = /* @__PURE__ */ jsx(StorageContext.Provider, { value: storage, children: props.children });
    $[5] = props.children;
    $[6] = storage;
    $[7] = t3;
  } else {
    t3 = $[7];
  }
  return t3;
}
const useStorageContext = createContextHook(StorageContext);
export {
  StorageContext,
  StorageContextProvider,
  useStorageContext
};
//# sourceMappingURL=storage.js.map
