import { jsx, jsxs } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { clsx } from "clsx";
/* empty css         */
import { DropdownMenu } from "../ui/dropdown.js";
import { Tooltip } from "../ui/tooltip.js";
const ToolbarMenuRoot = (t0) => {
  const $ = c(20);
  let button;
  let children;
  let label;
  let props;
  if ($[0] !== t0) {
    ({
      button,
      children,
      label,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = button;
    $[2] = children;
    $[3] = label;
    $[4] = props;
  } else {
    button = $[1];
    children = $[2];
    label = $[3];
    props = $[4];
  }
  let t1;
  if ($[5] !== props.className) {
    t1 = clsx("graphiql-un-styled graphiql-toolbar-menu", props.className);
    $[5] = props.className;
    $[6] = t1;
  } else {
    t1 = $[6];
  }
  let t2;
  if ($[7] !== button || $[8] !== label || $[9] !== t1) {
    t2 = /* @__PURE__ */ jsx(DropdownMenu.Button, { className: t1, "aria-label": label, children: button });
    $[7] = button;
    $[8] = label;
    $[9] = t1;
    $[10] = t2;
  } else {
    t2 = $[10];
  }
  let t3;
  if ($[11] !== label || $[12] !== t2) {
    t3 = /* @__PURE__ */ jsx(Tooltip, { label, children: t2 });
    $[11] = label;
    $[12] = t2;
    $[13] = t3;
  } else {
    t3 = $[13];
  }
  let t4;
  if ($[14] !== children) {
    t4 = /* @__PURE__ */ jsx(DropdownMenu.Content, { children });
    $[14] = children;
    $[15] = t4;
  } else {
    t4 = $[15];
  }
  let t5;
  if ($[16] !== props || $[17] !== t3 || $[18] !== t4) {
    t5 = /* @__PURE__ */ jsxs(DropdownMenu, { ...props, children: [
      t3,
      t4
    ] });
    $[16] = props;
    $[17] = t3;
    $[18] = t4;
    $[19] = t5;
  } else {
    t5 = $[19];
  }
  return t5;
};
const ToolbarMenu = Object.assign(ToolbarMenuRoot, {
  Item: DropdownMenu.Item
});
export {
  ToolbarMenu
};
//# sourceMappingURL=menu.js.map
