import { createContext, useContext } from "react";
function createNullableContext(name) {
  const context = createContext(null);
  context.displayName = name;
  return context;
}
function createContextHook(context) {
  function useGivenContext(options) {
    var _a;
    const value = useContext(context);
    if (value === null && (options == null ? void 0 : options.nonNull)) {
      throw new Error(`Tried to use \`${((_a = options.caller) == null ? void 0 : _a.name) || "a component"}\` without the necessary context. Make sure to render the \`${context.displayName}Provider\` component higher up the tree.`);
    }
    return value;
  }
  Object.defineProperty(useGivenContext, "name", {
    value: `use${context.displayName}`
  });
  return useGivenContext;
}
export {
  createContextHook,
  createNullableContext
};
//# sourceMappingURL=context.js.map
