import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { visit, parse } from "graphql";
import { useState, useRef, useEffect } from "react";
import { useStorage } from "../storage.js";
import { createNullableContext, createContextHook } from "../utility/context.js";
import { STORAGE_KEY as STORAGE_KEY$1 } from "./header-editor.js";
import { useSynchronizeValue } from "./hooks.js";
import { STORAGE_KEY_QUERY } from "./query-editor.js";
import { useStoreTabs, useSynchronizeActiveTabValues, useSetEditorValues, getDefaultTabState, serializeTabState, STORAGE_KEY as STORAGE_KEY$2, clearHeadersFromTabs, createTab, setPropertiesInActiveTab } from "./tabs.js";
import { STORAGE_KEY } from "./variable-editor.js";
import { DEFAULT_QUERY } from "../constants.js";
const EditorContext = createNullableContext("EditorContext");
const EditorContextProvider = (props) => {
  const $ = c(88);
  const storage = useStorage();
  const [headerEditor, setHeaderEditor] = useState(null);
  const [queryEditor, setQueryEditor] = useState(null);
  const [responseEditor, setResponseEditor] = useState(null);
  const [variableEditor, setVariableEditor] = useState(null);
  let t0;
  if ($[0] !== props.shouldPersistHeaders || $[1] !== storage) {
    t0 = () => {
      const isStored = storage.get(PERSIST_HEADERS_STORAGE_KEY) !== null;
      return props.shouldPersistHeaders !== false && isStored ? storage.get(PERSIST_HEADERS_STORAGE_KEY) === "true" : Boolean(props.shouldPersistHeaders);
    };
    $[0] = props.shouldPersistHeaders;
    $[1] = storage;
    $[2] = t0;
  } else {
    t0 = $[2];
  }
  const [shouldPersistHeaders, setShouldPersistHeadersInternal] = useState(t0);
  useSynchronizeValue(headerEditor, props.headers);
  useSynchronizeValue(queryEditor, props.query);
  useSynchronizeValue(responseEditor, props.response);
  useSynchronizeValue(variableEditor, props.variables);
  let t1;
  if ($[3] !== shouldPersistHeaders) {
    t1 = {
      shouldPersistHeaders
    };
    $[3] = shouldPersistHeaders;
    $[4] = t1;
  } else {
    t1 = $[4];
  }
  const storeTabs = useStoreTabs(t1);
  let t2;
  if ($[5] !== props.defaultHeaders || $[6] !== props.defaultQuery || $[7] !== props.defaultTabs || $[8] !== props.headers || $[9] !== props.query || $[10] !== props.response || $[11] !== props.variables || $[12] !== shouldPersistHeaders || $[13] !== storage || $[14] !== storeTabs) {
    t2 = () => {
      const query = props.query ?? storage.get(STORAGE_KEY_QUERY) ?? null;
      const variables = props.variables ?? storage.get(STORAGE_KEY) ?? null;
      const headers = props.headers ?? storage.get(STORAGE_KEY$1) ?? null;
      const response = props.response ?? "";
      const tabState = getDefaultTabState({
        query,
        variables,
        headers,
        defaultTabs: props.defaultTabs,
        defaultQuery: props.defaultQuery || DEFAULT_QUERY,
        defaultHeaders: props.defaultHeaders,
        shouldPersistHeaders
      });
      storeTabs(tabState);
      return {
        query: query ?? (tabState.activeTabIndex === 0 ? tabState.tabs[0].query : null) ?? "",
        variables: variables ?? "",
        headers: headers ?? props.defaultHeaders ?? "",
        response,
        tabState
      };
    };
    $[5] = props.defaultHeaders;
    $[6] = props.defaultQuery;
    $[7] = props.defaultTabs;
    $[8] = props.headers;
    $[9] = props.query;
    $[10] = props.response;
    $[11] = props.variables;
    $[12] = shouldPersistHeaders;
    $[13] = storage;
    $[14] = storeTabs;
    $[15] = t2;
  } else {
    t2 = $[15];
  }
  const [initialState] = useState(t2);
  const [tabState_0, setTabState] = useState(initialState.tabState);
  let t3;
  if ($[16] !== headerEditor || $[17] !== storage || $[18] !== tabState_0) {
    t3 = (persist) => {
      if (persist) {
        storage.set(STORAGE_KEY$1, (headerEditor == null ? void 0 : headerEditor.getValue()) ?? "");
        const serializedTabs = serializeTabState(tabState_0, true);
        storage.set(STORAGE_KEY$2, serializedTabs);
      } else {
        storage.set(STORAGE_KEY$1, "");
        clearHeadersFromTabs();
      }
      setShouldPersistHeadersInternal(persist);
      storage.set(PERSIST_HEADERS_STORAGE_KEY, persist.toString());
    };
    $[16] = headerEditor;
    $[17] = storage;
    $[18] = tabState_0;
    $[19] = t3;
  } else {
    t3 = $[19];
  }
  const setShouldPersistHeaders = t3;
  const lastShouldPersistHeadersProp = useRef(void 0);
  let t4;
  let t5;
  if ($[20] !== props.shouldPersistHeaders || $[21] !== setShouldPersistHeaders) {
    t4 = () => {
      const propValue = Boolean(props.shouldPersistHeaders);
      if ((lastShouldPersistHeadersProp == null ? void 0 : lastShouldPersistHeadersProp.current) !== propValue) {
        setShouldPersistHeaders(propValue);
        lastShouldPersistHeadersProp.current = propValue;
      }
    };
    t5 = [props.shouldPersistHeaders, setShouldPersistHeaders];
    $[20] = props.shouldPersistHeaders;
    $[21] = setShouldPersistHeaders;
    $[22] = t4;
    $[23] = t5;
  } else {
    t4 = $[22];
    t5 = $[23];
  }
  useEffect(t4, t5);
  let t6;
  if ($[24] !== headerEditor || $[25] !== queryEditor || $[26] !== responseEditor || $[27] !== variableEditor) {
    t6 = {
      queryEditor,
      variableEditor,
      headerEditor,
      responseEditor
    };
    $[24] = headerEditor;
    $[25] = queryEditor;
    $[26] = responseEditor;
    $[27] = variableEditor;
    $[28] = t6;
  } else {
    t6 = $[28];
  }
  const synchronizeActiveTabValues = useSynchronizeActiveTabValues(t6);
  const {
    onTabChange,
    defaultHeaders,
    defaultQuery,
    children
  } = props;
  let t7;
  if ($[29] !== defaultHeaders || $[30] !== headerEditor || $[31] !== queryEditor || $[32] !== responseEditor || $[33] !== variableEditor) {
    t7 = {
      queryEditor,
      variableEditor,
      headerEditor,
      responseEditor,
      defaultHeaders
    };
    $[29] = defaultHeaders;
    $[30] = headerEditor;
    $[31] = queryEditor;
    $[32] = responseEditor;
    $[33] = variableEditor;
    $[34] = t7;
  } else {
    t7 = $[34];
  }
  const setEditorValues = useSetEditorValues(t7);
  let t8;
  if ($[35] !== defaultHeaders || $[36] !== defaultQuery || $[37] !== onTabChange || $[38] !== setEditorValues || $[39] !== storeTabs || $[40] !== synchronizeActiveTabValues) {
    t8 = () => {
      setTabState((current) => {
        const updatedValues = synchronizeActiveTabValues(current);
        const updated = {
          tabs: [...updatedValues.tabs, createTab({
            headers: defaultHeaders,
            query: defaultQuery ?? DEFAULT_QUERY
          })],
          activeTabIndex: updatedValues.tabs.length
        };
        storeTabs(updated);
        setEditorValues(updated.tabs[updated.activeTabIndex]);
        onTabChange == null ? void 0 : onTabChange(updated);
        return updated;
      });
    };
    $[35] = defaultHeaders;
    $[36] = defaultQuery;
    $[37] = onTabChange;
    $[38] = setEditorValues;
    $[39] = storeTabs;
    $[40] = synchronizeActiveTabValues;
    $[41] = t8;
  } else {
    t8 = $[41];
  }
  const addTab = t8;
  let t9;
  if ($[42] !== onTabChange || $[43] !== setEditorValues || $[44] !== storeTabs) {
    t9 = (index) => {
      setTabState((current_0) => {
        const updated_0 = {
          ...current_0,
          activeTabIndex: index
        };
        storeTabs(updated_0);
        setEditorValues(updated_0.tabs[updated_0.activeTabIndex]);
        onTabChange == null ? void 0 : onTabChange(updated_0);
        return updated_0;
      });
    };
    $[42] = onTabChange;
    $[43] = setEditorValues;
    $[44] = storeTabs;
    $[45] = t9;
  } else {
    t9 = $[45];
  }
  const changeTab = t9;
  let t10;
  if ($[46] !== onTabChange || $[47] !== setEditorValues || $[48] !== storeTabs) {
    t10 = (newOrder) => {
      setTabState((current_1) => {
        const activeTab = current_1.tabs[current_1.activeTabIndex];
        const updated_1 = {
          tabs: newOrder,
          activeTabIndex: newOrder.indexOf(activeTab)
        };
        storeTabs(updated_1);
        setEditorValues(updated_1.tabs[updated_1.activeTabIndex]);
        onTabChange == null ? void 0 : onTabChange(updated_1);
        return updated_1;
      });
    };
    $[46] = onTabChange;
    $[47] = setEditorValues;
    $[48] = storeTabs;
    $[49] = t10;
  } else {
    t10 = $[49];
  }
  const moveTab = t10;
  let t11;
  if ($[50] !== onTabChange || $[51] !== setEditorValues || $[52] !== storeTabs) {
    t11 = (index_0) => {
      setTabState((current_2) => {
        const updated_2 = {
          tabs: current_2.tabs.filter((_tab, i) => index_0 !== i),
          activeTabIndex: Math.max(current_2.activeTabIndex - 1, 0)
        };
        storeTabs(updated_2);
        setEditorValues(updated_2.tabs[updated_2.activeTabIndex]);
        onTabChange == null ? void 0 : onTabChange(updated_2);
        return updated_2;
      });
    };
    $[50] = onTabChange;
    $[51] = setEditorValues;
    $[52] = storeTabs;
    $[53] = t11;
  } else {
    t11 = $[53];
  }
  const closeTab = t11;
  let t12;
  if ($[54] !== onTabChange || $[55] !== storeTabs) {
    t12 = (partialTab) => {
      setTabState((current_3) => {
        const updated_3 = setPropertiesInActiveTab(current_3, partialTab);
        storeTabs(updated_3);
        onTabChange == null ? void 0 : onTabChange(updated_3);
        return updated_3;
      });
    };
    $[54] = onTabChange;
    $[55] = storeTabs;
    $[56] = t12;
  } else {
    t12 = $[56];
  }
  const updateActiveTabValues = t12;
  const {
    onEditOperationName
  } = props;
  let t13;
  if ($[57] !== onEditOperationName || $[58] !== queryEditor || $[59] !== updateActiveTabValues) {
    t13 = (operationName) => {
      if (!queryEditor) {
        return;
      }
      updateQueryEditor(queryEditor, operationName);
      updateActiveTabValues({
        operationName
      });
      onEditOperationName == null ? void 0 : onEditOperationName(operationName);
    };
    $[57] = onEditOperationName;
    $[58] = queryEditor;
    $[59] = updateActiveTabValues;
    $[60] = t13;
  } else {
    t13 = $[60];
  }
  const setOperationName = t13;
  let t14;
  let map;
  if ($[61] !== props.externalFragments) {
    map = /* @__PURE__ */ new Map();
    if (Array.isArray(props.externalFragments)) {
      for (const fragment of props.externalFragments) {
        map.set(fragment.name.value, fragment);
      }
    } else {
      if (typeof props.externalFragments === "string") {
        visit(parse(props.externalFragments, {}), {
          FragmentDefinition(fragment_0) {
            map.set(fragment_0.name.value, fragment_0);
          }
        });
      } else {
        if (props.externalFragments) {
          throw new Error("The `externalFragments` prop must either be a string that contains the fragment definitions in SDL or a list of FragmentDefinitionNode objects.");
        }
      }
    }
    $[61] = props.externalFragments;
    $[62] = map;
  } else {
    map = $[62];
  }
  t14 = map;
  const externalFragments = t14;
  let t15;
  if ($[63] !== props.validationRules) {
    t15 = props.validationRules || [];
    $[63] = props.validationRules;
    $[64] = t15;
  } else {
    t15 = $[64];
  }
  const validationRules = t15;
  let t16;
  if ($[65] !== addTab || $[66] !== changeTab || $[67] !== closeTab || $[68] !== externalFragments || $[69] !== headerEditor || $[70] !== initialState.headers || $[71] !== initialState.query || $[72] !== initialState.response || $[73] !== initialState.variables || $[74] !== moveTab || $[75] !== queryEditor || $[76] !== responseEditor || $[77] !== setOperationName || $[78] !== setShouldPersistHeaders || $[79] !== shouldPersistHeaders || $[80] !== tabState_0 || $[81] !== updateActiveTabValues || $[82] !== validationRules || $[83] !== variableEditor) {
    t16 = {
      ...tabState_0,
      addTab,
      changeTab,
      moveTab,
      closeTab,
      updateActiveTabValues,
      headerEditor,
      queryEditor,
      responseEditor,
      variableEditor,
      setHeaderEditor,
      setQueryEditor,
      setResponseEditor,
      setVariableEditor,
      setOperationName,
      initialQuery: initialState.query,
      initialVariables: initialState.variables,
      initialHeaders: initialState.headers,
      initialResponse: initialState.response,
      externalFragments,
      validationRules,
      shouldPersistHeaders,
      setShouldPersistHeaders
    };
    $[65] = addTab;
    $[66] = changeTab;
    $[67] = closeTab;
    $[68] = externalFragments;
    $[69] = headerEditor;
    $[70] = initialState.headers;
    $[71] = initialState.query;
    $[72] = initialState.response;
    $[73] = initialState.variables;
    $[74] = moveTab;
    $[75] = queryEditor;
    $[76] = responseEditor;
    $[77] = setOperationName;
    $[78] = setShouldPersistHeaders;
    $[79] = shouldPersistHeaders;
    $[80] = tabState_0;
    $[81] = updateActiveTabValues;
    $[82] = validationRules;
    $[83] = variableEditor;
    $[84] = t16;
  } else {
    t16 = $[84];
  }
  const value = t16;
  let t17;
  if ($[85] !== children || $[86] !== value) {
    t17 = /* @__PURE__ */ jsx(EditorContext.Provider, { value, children });
    $[85] = children;
    $[86] = value;
    $[87] = t17;
  } else {
    t17 = $[87];
  }
  return t17;
};
function updateQueryEditor(queryEditor, operationName) {
  queryEditor.operationName = operationName;
}
const useEditorContext = createContextHook(EditorContext);
const PERSIST_HEADERS_STORAGE_KEY = "shouldPersistHeaders";
export {
  EditorContext,
  EditorContextProvider,
  useEditorContext
};
//# sourceMappingURL=context.js.map
