import { c } from "react-compiler-runtime";
import { useRef, useEffect } from "react";
import { useExecutionContext } from "../execution.js";
import { DEFAULT_EDITOR_THEME, commonKeys, DEFAULT_KEY_MAP, importCodeMirror } from "./common.js";
import { useEditorContext } from "./context.js";
import { useMergeQuery, usePrettifyEditors, useSynchronizeOption, useChangeHandler, useKeyMap } from "./hooks.js";
function importCodeMirrorImports() {
  return importCodeMirror([
    // @ts-expect-error
    import("codemirror/mode/javascript/javascript.js")
  ]);
}
const _useHeaderEditor = useHeaderEditor;
function useHeaderEditor(t0, caller) {
  const $ = c(17);
  let t1;
  if ($[0] !== t0) {
    t1 = t0 === void 0 ? {} : t0;
    $[0] = t0;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    editorTheme: t2,
    keyMap: t3,
    onEdit,
    readOnly: t4
  } = t1;
  const editorTheme = t2 === void 0 ? DEFAULT_EDITOR_THEME : t2;
  const keyMap = t3 === void 0 ? DEFAULT_KEY_MAP : t3;
  const readOnly = t4 === void 0 ? false : t4;
  const t5 = caller || _useHeaderEditor;
  let t6;
  if ($[2] !== t5) {
    t6 = {
      nonNull: true,
      caller: t5
    };
    $[2] = t5;
    $[3] = t6;
  } else {
    t6 = $[3];
  }
  const {
    initialHeaders,
    headerEditor,
    setHeaderEditor,
    shouldPersistHeaders
  } = useEditorContext(t6);
  const executionContext = useExecutionContext();
  const t7 = caller || _useHeaderEditor;
  let t8;
  if ($[4] !== t7) {
    t8 = {
      caller: t7
    };
    $[4] = t7;
    $[5] = t8;
  } else {
    t8 = $[5];
  }
  const merge = useMergeQuery(t8);
  const t9 = caller || _useHeaderEditor;
  let t10;
  if ($[6] !== t9) {
    t10 = {
      caller: t9
    };
    $[6] = t9;
    $[7] = t10;
  } else {
    t10 = $[7];
  }
  const prettify = usePrettifyEditors(t10);
  const ref = useRef(null);
  let t11;
  let t12;
  if ($[8] !== editorTheme || $[9] !== initialHeaders || $[10] !== readOnly || $[11] !== setHeaderEditor) {
    t11 = () => {
      let isActive;
      isActive = true;
      importCodeMirrorImports().then((CodeMirror) => {
        if (!isActive) {
          return;
        }
        const container = ref.current;
        if (!container) {
          return;
        }
        const newEditor = CodeMirror(container, {
          value: initialHeaders,
          lineNumbers: true,
          tabSize: 2,
          mode: {
            name: "javascript",
            json: true
          },
          theme: editorTheme,
          autoCloseBrackets: true,
          matchBrackets: true,
          showCursorWhenSelecting: true,
          readOnly: readOnly ? "nocursor" : false,
          foldGutter: true,
          gutters: ["CodeMirror-linenumbers", "CodeMirror-foldgutter"],
          extraKeys: commonKeys
        });
        newEditor.addKeyMap({
          "Cmd-Space"() {
            newEditor.showHint({
              completeSingle: false,
              container
            });
          },
          "Ctrl-Space"() {
            newEditor.showHint({
              completeSingle: false,
              container
            });
          },
          "Alt-Space"() {
            newEditor.showHint({
              completeSingle: false,
              container
            });
          },
          "Shift-Space"() {
            newEditor.showHint({
              completeSingle: false,
              container
            });
          }
        });
        newEditor.on("keyup", _temp);
        setHeaderEditor(newEditor);
      });
      return () => {
        isActive = false;
      };
    };
    t12 = [editorTheme, initialHeaders, readOnly, setHeaderEditor];
    $[8] = editorTheme;
    $[9] = initialHeaders;
    $[10] = readOnly;
    $[11] = setHeaderEditor;
    $[12] = t11;
    $[13] = t12;
  } else {
    t11 = $[12];
    t12 = $[13];
  }
  useEffect(t11, t12);
  useSynchronizeOption(headerEditor, "keyMap", keyMap);
  useChangeHandler(headerEditor, onEdit, shouldPersistHeaders ? STORAGE_KEY : null, "headers", _useHeaderEditor);
  let t13;
  if ($[14] === Symbol.for("react.memo_cache_sentinel")) {
    t13 = ["Cmd-Enter", "Ctrl-Enter"];
    $[14] = t13;
  } else {
    t13 = $[14];
  }
  useKeyMap(headerEditor, t13, executionContext == null ? void 0 : executionContext.run);
  let t14;
  if ($[15] === Symbol.for("react.memo_cache_sentinel")) {
    t14 = ["Shift-Ctrl-P"];
    $[15] = t14;
  } else {
    t14 = $[15];
  }
  useKeyMap(headerEditor, t14, prettify);
  let t15;
  if ($[16] === Symbol.for("react.memo_cache_sentinel")) {
    t15 = ["Shift-Ctrl-M"];
    $[16] = t15;
  } else {
    t15 = $[16];
  }
  useKeyMap(headerEditor, t15, merge);
  return ref;
}
function _temp(editorInstance, event) {
  const {
    code,
    key,
    shiftKey
  } = event;
  const isLetter = code.startsWith("Key");
  const isNumber = !shiftKey && code.startsWith("Digit");
  if (isLetter || isNumber || key === "_" || key === '"') {
    editorInstance.execCommand("autocomplete");
  }
}
const STORAGE_KEY = "headers";
export {
  STORAGE_KEY,
  useHeaderEditor
};
//# sourceMappingURL=header-editor.js.map
