import { c } from "react-compiler-runtime";
import { mergeAst, fillLeafs } from "@graphiql/toolkit";
import copyToClipboard from "copy-to-clipboard";
import { print, parse } from "graphql";
import { useCallback, useMemo, useRef, useState, useEffect } from "react";
import { usePluginStore } from "../plugin.js";
import { useSchemaStore } from "../schema.js";
import { storageStore } from "../storage.js";
import { onHasCompletion } from "./completion.js";
import { useEditorContext } from "./context.js";
import { debounce } from "../utility/debounce.js";
function useSynchronizeValue(editor, value) {
  const $ = c(4);
  let t0;
  let t1;
  if ($[0] !== editor || $[1] !== value) {
    t0 = () => {
      if (editor && typeof value === "string" && value !== editor.getValue()) {
        editor.setValue(value);
      }
    };
    t1 = [editor, value];
    $[0] = editor;
    $[1] = value;
    $[2] = t0;
    $[3] = t1;
  } else {
    t0 = $[2];
    t1 = $[3];
  }
  useEffect(t0, t1);
}
function useSynchronizeOption(editor, option, value) {
  const $ = c(5);
  let t0;
  let t1;
  if ($[0] !== editor || $[1] !== option || $[2] !== value) {
    t0 = () => {
      editor == null ? void 0 : editor.setOption(option, value);
    };
    t1 = [editor, option, value];
    $[0] = editor;
    $[1] = option;
    $[2] = value;
    $[3] = t0;
    $[4] = t1;
  } else {
    t0 = $[3];
    t1 = $[4];
  }
  useEffect(t0, t1);
}
function useChangeHandler(editor, callback, storageKey, tabProperty, caller) {
  const $ = c(9);
  let t0;
  if ($[0] !== caller) {
    t0 = {
      nonNull: true,
      caller
    };
    $[0] = caller;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  const {
    updateActiveTabValues
  } = useEditorContext(t0);
  let t1;
  let t2;
  if ($[2] !== callback || $[3] !== editor || $[4] !== storageKey || $[5] !== tabProperty || $[6] !== updateActiveTabValues) {
    t1 = () => {
      if (!editor) {
        return;
      }
      const {
        storage
      } = storageStore.getState();
      const store = debounce(500, (value) => {
        if (storageKey === null) {
          return;
        }
        storage.set(storageKey, value);
      });
      const updateTab = debounce(100, (value_0) => {
        updateActiveTabValues({
          [tabProperty]: value_0
        });
      });
      const handleChange = (editorInstance, changeObj) => {
        if (!changeObj) {
          return;
        }
        const newValue = editorInstance.getValue();
        store(newValue);
        updateTab(newValue);
        callback == null ? void 0 : callback(newValue);
      };
      editor.on("change", handleChange);
      return () => editor.off("change", handleChange);
    };
    t2 = [callback, editor, storageKey, tabProperty, updateActiveTabValues];
    $[2] = callback;
    $[3] = editor;
    $[4] = storageKey;
    $[5] = tabProperty;
    $[6] = updateActiveTabValues;
    $[7] = t1;
    $[8] = t2;
  } else {
    t1 = $[7];
    t2 = $[8];
  }
  useEffect(t1, t2);
}
function useCompletion(editor, callback) {
  const $ = c(7);
  const {
    schema,
    setSchemaReference
  } = useSchemaStore();
  const plugin = usePluginStore();
  let t0;
  let t1;
  if ($[0] !== callback || $[1] !== editor || $[2] !== plugin || $[3] !== schema || $[4] !== setSchemaReference) {
    t0 = () => {
      if (!editor) {
        return;
      }
      const handleCompletion = (instance, changeObj) => {
        const schemaContext = {
          schema,
          setSchemaReference
        };
        onHasCompletion(instance, changeObj, schemaContext, plugin, (type) => {
          callback == null ? void 0 : callback({
            kind: "Type",
            type,
            schema: schema || void 0
          });
        });
      };
      editor.on("hasCompletion", handleCompletion);
      return () => editor.off("hasCompletion", handleCompletion);
    };
    t1 = [callback, editor, plugin, schema, setSchemaReference];
    $[0] = callback;
    $[1] = editor;
    $[2] = plugin;
    $[3] = schema;
    $[4] = setSchemaReference;
    $[5] = t0;
    $[6] = t1;
  } else {
    t0 = $[5];
    t1 = $[6];
  }
  useEffect(t0, t1);
}
function useKeyMap(editor, keys, callback) {
  const $ = c(5);
  let t0;
  let t1;
  if ($[0] !== callback || $[1] !== editor || $[2] !== keys) {
    t0 = () => {
      if (!editor) {
        return;
      }
      for (const key of keys) {
        editor.removeKeyMap(key);
      }
      if (callback) {
        const keyMap = {};
        for (const key_0 of keys) {
          keyMap[key_0] = () => callback();
        }
        editor.addKeyMap(keyMap);
      }
    };
    t1 = [editor, keys, callback];
    $[0] = callback;
    $[1] = editor;
    $[2] = keys;
    $[3] = t0;
    $[4] = t1;
  } else {
    t0 = $[3];
    t1 = $[4];
  }
  useEffect(t0, t1);
}
const _useCopyQuery = useCopyQuery;
const _useMergeQuery = useMergeQuery;
const _usePrettifyEditors = usePrettifyEditors;
const _useAutoCompleteLeafs = useAutoCompleteLeafs;
function useCopyQuery(t0) {
  const $ = c(7);
  let t1;
  if ($[0] !== t0) {
    t1 = t0 === void 0 ? {} : t0;
    $[0] = t0;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    caller,
    onCopyQuery
  } = t1;
  const t2 = caller || _useCopyQuery;
  let t3;
  if ($[2] !== t2) {
    t3 = {
      nonNull: true,
      caller: t2
    };
    $[2] = t2;
    $[3] = t3;
  } else {
    t3 = $[3];
  }
  const {
    queryEditor
  } = useEditorContext(t3);
  let t4;
  if ($[4] !== onCopyQuery || $[5] !== queryEditor) {
    t4 = () => {
      if (!queryEditor) {
        return;
      }
      const query = queryEditor.getValue();
      copyToClipboard(query);
      onCopyQuery == null ? void 0 : onCopyQuery(query);
    };
    $[4] = onCopyQuery;
    $[5] = queryEditor;
    $[6] = t4;
  } else {
    t4 = $[6];
  }
  return t4;
}
function useMergeQuery(t0) {
  const $ = c(7);
  let t1;
  if ($[0] !== t0) {
    t1 = t0 === void 0 ? {} : t0;
    $[0] = t0;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    caller
  } = t1;
  const t2 = caller || _useMergeQuery;
  let t3;
  if ($[2] !== t2) {
    t3 = {
      nonNull: true,
      caller: t2
    };
    $[2] = t2;
    $[3] = t3;
  } else {
    t3 = $[3];
  }
  const {
    queryEditor
  } = useEditorContext(t3);
  const {
    schema
  } = useSchemaStore();
  let t4;
  if ($[4] !== queryEditor || $[5] !== schema) {
    t4 = () => {
      const documentAST = queryEditor == null ? void 0 : queryEditor.documentAST;
      const query = queryEditor == null ? void 0 : queryEditor.getValue();
      if (!documentAST || !query) {
        return;
      }
      queryEditor.setValue(print(mergeAst(documentAST, schema)));
    };
    $[4] = queryEditor;
    $[5] = schema;
    $[6] = t4;
  } else {
    t4 = $[6];
  }
  return t4;
}
function DEFAULT_PRETTIFY_QUERY(query) {
  return print(parse(query));
}
function usePrettifyEditors(t0) {
  const $ = c(9);
  let t1;
  if ($[0] !== t0) {
    t1 = t0 === void 0 ? {} : t0;
    $[0] = t0;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    caller,
    onPrettifyQuery: t2
  } = t1;
  const onPrettifyQuery = t2 === void 0 ? DEFAULT_PRETTIFY_QUERY : t2;
  const t3 = caller || _usePrettifyEditors;
  let t4;
  if ($[2] !== t3) {
    t4 = {
      nonNull: true,
      caller: t3
    };
    $[2] = t3;
    $[3] = t4;
  } else {
    t4 = $[3];
  }
  const {
    queryEditor,
    headerEditor,
    variableEditor
  } = useEditorContext(t4);
  let t5;
  if ($[4] !== headerEditor || $[5] !== onPrettifyQuery || $[6] !== queryEditor || $[7] !== variableEditor) {
    t5 = async () => {
      if (variableEditor) {
        const variableEditorContent = variableEditor.getValue();
        try {
          const prettifiedVariableEditorContent = JSON.stringify(JSON.parse(variableEditorContent), null, 2);
          if (prettifiedVariableEditorContent !== variableEditorContent) {
            variableEditor.setValue(prettifiedVariableEditorContent);
          }
        } catch {
        }
      }
      if (headerEditor) {
        const headerEditorContent = headerEditor.getValue();
        try {
          const prettifiedHeaderEditorContent = JSON.stringify(JSON.parse(headerEditorContent), null, 2);
          if (prettifiedHeaderEditorContent !== headerEditorContent) {
            headerEditor.setValue(prettifiedHeaderEditorContent);
          }
        } catch {
        }
      }
      if (queryEditor) {
        const editorContent = queryEditor.getValue();
        try {
          const prettifiedEditorContent = await onPrettifyQuery(editorContent);
          if (prettifiedEditorContent !== editorContent) {
            queryEditor.setValue(prettifiedEditorContent);
          }
        } catch {
        }
      }
    };
    $[4] = headerEditor;
    $[5] = onPrettifyQuery;
    $[6] = queryEditor;
    $[7] = variableEditor;
    $[8] = t5;
  } else {
    t5 = $[8];
  }
  return t5;
}
function useAutoCompleteLeafs(t0) {
  const $ = c(8);
  let t1;
  if ($[0] !== t0) {
    t1 = t0 === void 0 ? {} : t0;
    $[0] = t0;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    getDefaultFieldNames,
    caller
  } = t1;
  const {
    schema
  } = useSchemaStore();
  const t2 = caller || _useAutoCompleteLeafs;
  let t3;
  if ($[2] !== t2) {
    t3 = {
      nonNull: true,
      caller: t2
    };
    $[2] = t2;
    $[3] = t3;
  } else {
    t3 = $[3];
  }
  const {
    queryEditor
  } = useEditorContext(t3);
  let t4;
  if ($[4] !== getDefaultFieldNames || $[5] !== queryEditor || $[6] !== schema) {
    t4 = () => {
      if (!queryEditor) {
        return;
      }
      const query = queryEditor.getValue();
      const {
        insertions,
        result
      } = fillLeafs(schema, query, getDefaultFieldNames);
      if (insertions && insertions.length > 0) {
        queryEditor.operation(() => {
          const cursor = queryEditor.getCursor();
          const cursorIndex = queryEditor.indexFromPos(cursor);
          queryEditor.setValue(result || "");
          let added;
          added = 0;
          const markers = insertions.map((t5) => {
            const {
              index,
              string
            } = t5;
            added = added + string.length;
            return queryEditor.markText(queryEditor.posFromIndex(index + added), queryEditor.posFromIndex(index + added), {
              className: "auto-inserted-leaf",
              clearOnEnter: true,
              title: "Automatically added leaf fields"
            });
          });
          setTimeout(() => {
            for (const marker of markers) {
              marker.clear();
            }
          }, 7e3);
          let newCursorIndex = cursorIndex;
          for (const {
            index: index_0,
            string: string_0
          } of insertions) {
            if (index_0 < cursorIndex) {
              newCursorIndex = newCursorIndex + string_0.length;
            }
          }
          queryEditor.setCursor(queryEditor.posFromIndex(newCursorIndex));
        });
      }
      return result;
    };
    $[4] = getDefaultFieldNames;
    $[5] = queryEditor;
    $[6] = schema;
    $[7] = t4;
  } else {
    t4 = $[7];
  }
  return t4;
}
const useEditorState = (editor) => {
  "use no memo";
  const context = useEditorContext({
    nonNull: true
  });
  const editorInstance = context[`${editor}Editor`];
  let valueString = "";
  const editorValue = (editorInstance == null ? void 0 : editorInstance.getValue()) ?? false;
  if (editorValue && editorValue.length > 0) {
    valueString = editorValue;
  }
  const handleEditorValue = useCallback((value) => editorInstance == null ? void 0 : editorInstance.setValue(value), [editorInstance]);
  return useMemo(() => [valueString, handleEditorValue], [valueString, handleEditorValue]);
};
const useOperationsEditorState = () => {
  return useEditorState("query");
};
const useVariablesEditorState = () => {
  return useEditorState("variable");
};
const useHeadersEditorState = () => {
  return useEditorState("header");
};
function useOptimisticState(t0) {
  const $ = c(12);
  const [upstreamState, upstreamSetState] = t0;
  let t1;
  if ($[0] !== upstreamState) {
    t1 = {
      pending: null,
      last: upstreamState
    };
    $[0] = upstreamState;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const lastStateRef = useRef(t1);
  const [state, setOperationsText] = useState(upstreamState);
  let t2;
  let t3;
  if ($[2] !== state || $[3] !== upstreamSetState || $[4] !== upstreamState) {
    t2 = () => {
      if (lastStateRef.current.last === upstreamState) ;
      else {
        lastStateRef.current.last = upstreamState;
        if (lastStateRef.current.pending === null) {
          setOperationsText(upstreamState);
        } else {
          if (lastStateRef.current.pending === upstreamState) {
            lastStateRef.current.pending = null;
            if (upstreamState !== state) {
              lastStateRef.current.pending = state;
              upstreamSetState(state);
            }
          } else {
            lastStateRef.current.pending = null;
            setOperationsText(upstreamState);
          }
        }
      }
    };
    t3 = [upstreamState, state, upstreamSetState];
    $[2] = state;
    $[3] = upstreamSetState;
    $[4] = upstreamState;
    $[5] = t2;
    $[6] = t3;
  } else {
    t2 = $[5];
    t3 = $[6];
  }
  useEffect(t2, t3);
  let t4;
  if ($[7] !== upstreamSetState) {
    t4 = (newState) => {
      setOperationsText(newState);
      if (lastStateRef.current.pending === null && lastStateRef.current.last !== newState) {
        lastStateRef.current.pending = newState;
        upstreamSetState(newState);
      }
    };
    $[7] = upstreamSetState;
    $[8] = t4;
  } else {
    t4 = $[8];
  }
  const setState = t4;
  let t5;
  if ($[9] !== setState || $[10] !== state) {
    t5 = [state, setState];
    $[9] = setState;
    $[10] = state;
    $[11] = t5;
  } else {
    t5 = $[11];
  }
  return t5;
}
export {
  useAutoCompleteLeafs,
  useChangeHandler,
  useCompletion,
  useCopyQuery,
  useEditorState,
  useHeadersEditorState,
  useKeyMap,
  useMergeQuery,
  useOperationsEditorState,
  useOptimisticState,
  usePrettifyEditors,
  useSynchronizeOption,
  useSynchronizeValue,
  useVariablesEditorState
};
//# sourceMappingURL=hooks.js.map
