import { c } from "react-compiler-runtime";
import { getSelectedOperationName } from "@graphiql/toolkit";
import { GraphQLDocumentMode, getOperationFacts } from "graphql-language-service";
import { useRef, useEffect } from "react";
import { useExecutionContext } from "../execution.js";
import { markdown } from "../markdown.js";
import { usePluginStore } from "../plugin.js";
import { useSchemaStore } from "../schema.js";
import { useStorage } from "../storage.js";
import { debounce } from "../utility/debounce.js";
import { DEFAULT_EDITOR_THEME, commonKeys, DEFAULT_KEY_MAP, importCodeMirror } from "./common.js";
import { useEditorContext } from "./context.js";
import { useCopyQuery, useMergeQuery, usePrettifyEditors, useSynchronizeOption, useCompletion, useKeyMap } from "./hooks.js";
import { normalizeWhitespace } from "./whitespace.js";
function importCodeMirrorImports() {
  return importCodeMirror([import("codemirror/addon/comment/comment.js"), import("codemirror/addon/search/search.js"), import("codemirror-graphql/esm/hint.js"), import("codemirror-graphql/esm/lint.js"), import("codemirror-graphql/esm/info.js"), import("codemirror-graphql/esm/jump.js"), import("codemirror-graphql/esm/mode.js")]);
}
const _useQueryEditor = useQueryEditor;
function updateVariableEditor(variableEditor, operationFacts) {
  variableEditor.state.lint.linterOptions.variableToType = operationFacts == null ? void 0 : operationFacts.variableToType;
  variableEditor.options.lint.variableToType = operationFacts == null ? void 0 : operationFacts.variableToType;
  variableEditor.options.hintOptions.variableToType = operationFacts == null ? void 0 : operationFacts.variableToType;
}
function updateEditorSchema(editor, schema) {
  editor.state.lint.linterOptions.schema = schema;
  editor.options.lint.schema = schema;
  editor.options.hintOptions.schema = schema;
  editor.options.info.schema = schema;
  editor.options.jump.schema = schema;
}
function updateEditorValidationRules(editor, validationRules) {
  editor.state.lint.linterOptions.validationRules = validationRules;
  editor.options.lint.validationRules = validationRules;
}
function updateEditorExternalFragments(editor, externalFragmentList) {
  editor.state.lint.linterOptions.externalFragments = externalFragmentList;
  editor.options.lint.externalFragments = externalFragmentList;
  editor.options.hintOptions.externalFragments = externalFragmentList;
}
function useQueryEditor(t0, caller) {
  const $ = c(40);
  let t1;
  if ($[0] !== t0) {
    t1 = t0 === void 0 ? {} : t0;
    $[0] = t0;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    editorTheme: t2,
    keyMap: t3,
    onClickReference,
    onCopyQuery,
    onEdit,
    onPrettifyQuery,
    readOnly: t4
  } = t1;
  const editorTheme = t2 === void 0 ? DEFAULT_EDITOR_THEME : t2;
  const keyMap = t3 === void 0 ? DEFAULT_KEY_MAP : t3;
  const readOnly = t4 === void 0 ? false : t4;
  const {
    schema,
    setSchemaReference
  } = useSchemaStore();
  const t5 = caller || _useQueryEditor;
  let t6;
  if ($[2] !== t5) {
    t6 = {
      nonNull: true,
      caller: t5
    };
    $[2] = t5;
    $[3] = t6;
  } else {
    t6 = $[3];
  }
  const {
    externalFragments,
    initialQuery,
    queryEditor,
    setOperationName,
    setQueryEditor,
    validationRules,
    variableEditor,
    updateActiveTabValues
  } = useEditorContext(t6);
  const executionContext = useExecutionContext();
  const storage = useStorage();
  const plugin = usePluginStore();
  const t7 = caller || _useQueryEditor;
  let t8;
  if ($[4] !== onCopyQuery || $[5] !== t7) {
    t8 = {
      caller: t7,
      onCopyQuery
    };
    $[4] = onCopyQuery;
    $[5] = t7;
    $[6] = t8;
  } else {
    t8 = $[6];
  }
  const copy = useCopyQuery(t8);
  const t9 = caller || _useQueryEditor;
  let t10;
  if ($[7] !== t9) {
    t10 = {
      caller: t9
    };
    $[7] = t9;
    $[8] = t10;
  } else {
    t10 = $[8];
  }
  const merge = useMergeQuery(t10);
  const t11 = caller || _useQueryEditor;
  let t12;
  if ($[9] !== onPrettifyQuery || $[10] !== t11) {
    t12 = {
      caller: t11,
      onPrettifyQuery
    };
    $[9] = onPrettifyQuery;
    $[10] = t11;
    $[11] = t12;
  } else {
    t12 = $[11];
  }
  const prettify = usePrettifyEditors(t12);
  const ref = useRef(null);
  const codeMirrorRef = useRef(void 0);
  const onClickReferenceRef = useRef(_temp);
  let t13;
  let t14;
  if ($[12] !== onClickReference || $[13] !== plugin || $[14] !== setSchemaReference) {
    t13 = () => {
      onClickReferenceRef.current = (reference) => {
        const referencePlugin = plugin == null ? void 0 : plugin.referencePlugin;
        if (!referencePlugin) {
          return;
        }
        plugin.setVisiblePlugin(referencePlugin);
        setSchemaReference(reference);
        onClickReference == null ? void 0 : onClickReference(reference);
      };
    };
    t14 = [onClickReference, plugin, setSchemaReference];
    $[12] = onClickReference;
    $[13] = plugin;
    $[14] = setSchemaReference;
    $[15] = t13;
    $[16] = t14;
  } else {
    t13 = $[15];
    t14 = $[16];
  }
  useEffect(t13, t14);
  let t15;
  let t16;
  if ($[17] !== editorTheme || $[18] !== initialQuery || $[19] !== readOnly || $[20] !== setQueryEditor) {
    t15 = () => {
      let isActive;
      isActive = true;
      importCodeMirrorImports().then((CodeMirror) => {
        if (!isActive) {
          return;
        }
        codeMirrorRef.current = CodeMirror;
        const container = ref.current;
        if (!container) {
          return;
        }
        const newEditor = CodeMirror(container, {
          value: initialQuery,
          lineNumbers: true,
          tabSize: 2,
          foldGutter: true,
          mode: "graphql",
          theme: editorTheme,
          autoCloseBrackets: true,
          matchBrackets: true,
          showCursorWhenSelecting: true,
          readOnly: readOnly ? "nocursor" : false,
          lint: {
            schema: void 0,
            validationRules: null,
            externalFragments: void 0
          },
          hintOptions: {
            schema: void 0,
            closeOnUnfocus: false,
            completeSingle: false,
            container,
            externalFragments: void 0,
            autocompleteOptions: {
              mode: GraphQLDocumentMode.EXECUTABLE
            }
          },
          info: {
            schema: void 0,
            renderDescription: _temp2,
            onClick(reference_0) {
              onClickReferenceRef.current(reference_0);
            }
          },
          jump: {
            schema: void 0,
            onClick(reference_1) {
              onClickReferenceRef.current(reference_1);
            }
          },
          gutters: ["CodeMirror-linenumbers", "CodeMirror-foldgutter"],
          extraKeys: {
            ...commonKeys,
            "Cmd-S"() {
            },
            "Ctrl-S"() {
            }
          }
        });
        const showHint = function showHint2() {
          newEditor.showHint({
            completeSingle: true,
            container
          });
        };
        newEditor.addKeyMap({
          "Cmd-Space": showHint,
          "Ctrl-Space": showHint,
          "Alt-Space": showHint,
          "Shift-Space": showHint,
          "Shift-Alt-Space": showHint
        });
        newEditor.on("keyup", _temp3);
        let showingHints;
        showingHints = false;
        newEditor.on("startCompletion", () => {
          showingHints = true;
        });
        newEditor.on("endCompletion", () => {
          showingHints = false;
        });
        newEditor.on("keydown", (editorInstance_0, event_0) => {
          if (event_0.key === "Escape" && showingHints) {
            event_0.stopPropagation();
          }
        });
        newEditor.on("beforeChange", _temp4);
        newEditor.documentAST = null;
        newEditor.operationName = null;
        newEditor.operations = null;
        newEditor.variableToType = null;
        setQueryEditor(newEditor);
      });
      return () => {
        isActive = false;
      };
    };
    t16 = [editorTheme, initialQuery, readOnly, setQueryEditor];
    $[17] = editorTheme;
    $[18] = initialQuery;
    $[19] = readOnly;
    $[20] = setQueryEditor;
    $[21] = t15;
    $[22] = t16;
  } else {
    t15 = $[21];
    t16 = $[22];
  }
  useEffect(t15, t16);
  useSynchronizeOption(queryEditor, "keyMap", keyMap);
  let t17;
  let t18;
  if ($[23] !== onEdit || $[24] !== queryEditor || $[25] !== schema || $[26] !== setOperationName || $[27] !== storage || $[28] !== updateActiveTabValues || $[29] !== variableEditor) {
    t17 = () => {
      if (!queryEditor) {
        return;
      }
      const getAndUpdateOperationFacts = function getAndUpdateOperationFacts2(editorInstance_2) {
        var _a;
        const operationFacts = getOperationFacts(schema, editorInstance_2.getValue());
        const operationName = getSelectedOperationName(editorInstance_2.operations ?? void 0, editorInstance_2.operationName ?? void 0, operationFacts == null ? void 0 : operationFacts.operations);
        editorInstance_2.documentAST = (operationFacts == null ? void 0 : operationFacts.documentAST) ?? null;
        editorInstance_2.operationName = operationName ?? null;
        editorInstance_2.operations = (operationFacts == null ? void 0 : operationFacts.operations) ?? null;
        if (variableEditor) {
          updateVariableEditor(variableEditor, operationFacts);
          (_a = codeMirrorRef.current) == null ? void 0 : _a.signal(variableEditor, "change", variableEditor);
        }
        return operationFacts ? {
          ...operationFacts,
          operationName
        } : null;
      };
      const handleChange = debounce(100, (editorInstance_3) => {
        const query = editorInstance_3.getValue();
        storage.set(STORAGE_KEY_QUERY, query);
        const currentOperationName = editorInstance_3.operationName;
        const operationFacts_0 = getAndUpdateOperationFacts(editorInstance_3);
        if ((operationFacts_0 == null ? void 0 : operationFacts_0.operationName) !== void 0) {
          storage.set(STORAGE_KEY_OPERATION_NAME, operationFacts_0.operationName);
        }
        onEdit == null ? void 0 : onEdit(query, operationFacts_0 == null ? void 0 : operationFacts_0.documentAST);
        if ((operationFacts_0 == null ? void 0 : operationFacts_0.operationName) && currentOperationName !== operationFacts_0.operationName) {
          setOperationName(operationFacts_0.operationName);
        }
        updateActiveTabValues({
          query,
          operationName: (operationFacts_0 == null ? void 0 : operationFacts_0.operationName) ?? null
        });
      });
      getAndUpdateOperationFacts(queryEditor);
      queryEditor.on("change", handleChange);
      return () => queryEditor.off("change", handleChange);
    };
    t18 = [onEdit, queryEditor, schema, setOperationName, storage, variableEditor, updateActiveTabValues];
    $[23] = onEdit;
    $[24] = queryEditor;
    $[25] = schema;
    $[26] = setOperationName;
    $[27] = storage;
    $[28] = updateActiveTabValues;
    $[29] = variableEditor;
    $[30] = t17;
    $[31] = t18;
  } else {
    t17 = $[30];
    t18 = $[31];
  }
  useEffect(t17, t18);
  useSynchronizeSchema(queryEditor, schema ?? null, codeMirrorRef);
  useSynchronizeValidationRules(queryEditor, validationRules ?? null, codeMirrorRef);
  useSynchronizeExternalFragments(queryEditor, externalFragments, codeMirrorRef);
  useCompletion(queryEditor, onClickReference);
  const run = executionContext == null ? void 0 : executionContext.run;
  let t19;
  if ($[32] !== queryEditor || $[33] !== run || $[34] !== setOperationName) {
    t19 = () => {
      var _a;
      if (!run || !queryEditor || !queryEditor.operations || !queryEditor.hasFocus()) {
        run == null ? void 0 : run();
        return;
      }
      const cursorIndex = queryEditor.indexFromPos(queryEditor.getCursor());
      let operationName_0;
      for (const operation of queryEditor.operations) {
        if (operation.loc && operation.loc.start <= cursorIndex && operation.loc.end >= cursorIndex) {
          operationName_0 = (_a = operation.name) == null ? void 0 : _a.value;
        }
      }
      if (operationName_0 && operationName_0 !== queryEditor.operationName) {
        setOperationName(operationName_0);
      }
      run();
    };
    $[32] = queryEditor;
    $[33] = run;
    $[34] = setOperationName;
    $[35] = t19;
  } else {
    t19 = $[35];
  }
  const runAtCursor = t19;
  let t20;
  if ($[36] === Symbol.for("react.memo_cache_sentinel")) {
    t20 = ["Cmd-Enter", "Ctrl-Enter"];
    $[36] = t20;
  } else {
    t20 = $[36];
  }
  useKeyMap(queryEditor, t20, runAtCursor);
  let t21;
  if ($[37] === Symbol.for("react.memo_cache_sentinel")) {
    t21 = ["Shift-Ctrl-C"];
    $[37] = t21;
  } else {
    t21 = $[37];
  }
  useKeyMap(queryEditor, t21, copy);
  let t22;
  if ($[38] === Symbol.for("react.memo_cache_sentinel")) {
    t22 = ["Shift-Ctrl-P", "Shift-Ctrl-F"];
    $[38] = t22;
  } else {
    t22 = $[38];
  }
  useKeyMap(queryEditor, t22, prettify);
  let t23;
  if ($[39] === Symbol.for("react.memo_cache_sentinel")) {
    t23 = ["Shift-Ctrl-M"];
    $[39] = t23;
  } else {
    t23 = $[39];
  }
  useKeyMap(queryEditor, t23, merge);
  return ref;
}
function _temp4(editorInstance_1, change) {
  var _a;
  if (change.origin === "paste") {
    const text_0 = change.text.map(normalizeWhitespace);
    (_a = change.update) == null ? void 0 : _a.call(change, change.from, change.to, text_0);
  }
}
function _temp3(editorInstance, event) {
  if (AUTO_COMPLETE_AFTER_KEY.test(event.key)) {
    editorInstance.execCommand("autocomplete");
  }
}
function _temp2(text) {
  return markdown.render(text);
}
function _temp() {
}
function useSynchronizeSchema(editor, schema, codeMirrorRef) {
  const $ = c(5);
  let t0;
  let t1;
  if ($[0] !== codeMirrorRef || $[1] !== editor || $[2] !== schema) {
    t0 = () => {
      if (!editor) {
        return;
      }
      const didChange = editor.options.lint.schema !== schema;
      updateEditorSchema(editor, schema);
      if (didChange && codeMirrorRef.current) {
        codeMirrorRef.current.signal(editor, "change", editor);
      }
    };
    t1 = [editor, schema, codeMirrorRef];
    $[0] = codeMirrorRef;
    $[1] = editor;
    $[2] = schema;
    $[3] = t0;
    $[4] = t1;
  } else {
    t0 = $[3];
    t1 = $[4];
  }
  useEffect(t0, t1);
}
function useSynchronizeValidationRules(editor, validationRules, codeMirrorRef) {
  const $ = c(5);
  let t0;
  let t1;
  if ($[0] !== codeMirrorRef || $[1] !== editor || $[2] !== validationRules) {
    t0 = () => {
      if (!editor) {
        return;
      }
      const didChange = editor.options.lint.validationRules !== validationRules;
      updateEditorValidationRules(editor, validationRules);
      if (didChange && codeMirrorRef.current) {
        codeMirrorRef.current.signal(editor, "change", editor);
      }
    };
    t1 = [editor, validationRules, codeMirrorRef];
    $[0] = codeMirrorRef;
    $[1] = editor;
    $[2] = validationRules;
    $[3] = t0;
    $[4] = t1;
  } else {
    t0 = $[3];
    t1 = $[4];
  }
  useEffect(t0, t1);
}
function useSynchronizeExternalFragments(editor, externalFragments, codeMirrorRef) {
  const $ = c(7);
  let t0;
  if ($[0] !== externalFragments) {
    t0 = [...externalFragments.values()];
    $[0] = externalFragments;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  const externalFragmentList = t0;
  let t1;
  let t2;
  if ($[2] !== codeMirrorRef || $[3] !== editor || $[4] !== externalFragmentList) {
    t1 = () => {
      if (!editor) {
        return;
      }
      const didChange = editor.options.lint.externalFragments !== externalFragmentList;
      updateEditorExternalFragments(editor, externalFragmentList);
      if (didChange && codeMirrorRef.current) {
        codeMirrorRef.current.signal(editor, "change", editor);
      }
    };
    t2 = [editor, externalFragmentList, codeMirrorRef];
    $[2] = codeMirrorRef;
    $[3] = editor;
    $[4] = externalFragmentList;
    $[5] = t1;
    $[6] = t2;
  } else {
    t1 = $[5];
    t2 = $[6];
  }
  useEffect(t1, t2);
}
const AUTO_COMPLETE_AFTER_KEY = /^[a-zA-Z0-9_@(]$/;
const STORAGE_KEY_QUERY = "query";
const STORAGE_KEY_OPERATION_NAME = "operationName";
export {
  STORAGE_KEY_QUERY,
  useQueryEditor
};
//# sourceMappingURL=query-editor.js.map
