import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { formatError } from "@graphiql/toolkit";
import { useRef, useEffect } from "react";
import { createRoot } from "react-dom/client";
import { useSchemaStore } from "../schema.js";
import { DEFAULT_EDITOR_THEME, commonKeys, DEFAULT_KEY_MAP, importCodeMirror } from "./common.js";
import { useEditorContext } from "./context.js";
import { useSynchronizeOption } from "./hooks.js";
import { ImagePreview } from "./components/image-preview.js";
function importCodeMirrorImports() {
  return importCodeMirror([
    import("codemirror/addon/fold/foldgutter.js"),
    import("codemirror/addon/fold/brace-fold.js"),
    import("codemirror/addon/dialog/dialog.js"),
    import("codemirror/addon/search/search.js"),
    import("codemirror/addon/search/searchcursor.js"),
    import("codemirror/addon/search/jump-to-line.js"),
    // @ts-expect-error
    import("codemirror/keymap/sublime.js"),
    import("codemirror-graphql/esm/results/mode.js"),
    import("codemirror-graphql/esm/utils/info-addon.js")
  ], {
    useCommonAddons: false
  });
}
const _useResponseEditor = useResponseEditor;
function useResponseEditor(t0, caller) {
  const $ = c(17);
  let t1;
  if ($[0] !== t0) {
    t1 = t0 === void 0 ? {} : t0;
    $[0] = t0;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const {
    responseTooltip,
    editorTheme: t2,
    keyMap: t3
  } = t1;
  const editorTheme = t2 === void 0 ? DEFAULT_EDITOR_THEME : t2;
  const keyMap = t3 === void 0 ? DEFAULT_KEY_MAP : t3;
  const {
    fetchError,
    validationErrors
  } = useSchemaStore();
  const t4 = caller || _useResponseEditor;
  let t5;
  if ($[2] !== t4) {
    t5 = {
      nonNull: true,
      caller: t4
    };
    $[2] = t4;
    $[3] = t5;
  } else {
    t5 = $[3];
  }
  const {
    initialResponse,
    responseEditor,
    setResponseEditor
  } = useEditorContext(t5);
  const ref = useRef(null);
  const responseTooltipRef = useRef(responseTooltip);
  let t6;
  let t7;
  if ($[4] !== responseTooltip) {
    t6 = () => {
      responseTooltipRef.current = responseTooltip;
    };
    t7 = [responseTooltip];
    $[4] = responseTooltip;
    $[5] = t6;
    $[6] = t7;
  } else {
    t6 = $[5];
    t7 = $[6];
  }
  useEffect(t6, t7);
  let t8;
  let t9;
  if ($[7] !== editorTheme || $[8] !== initialResponse || $[9] !== setResponseEditor) {
    t8 = () => {
      let isActive;
      isActive = true;
      importCodeMirrorImports().then((CodeMirror) => {
        if (!isActive) {
          return;
        }
        const tooltipContainer = document.createElement("div");
        const tooltipRoot = createRoot(tooltipContainer);
        CodeMirror.registerHelper("info", "graphql-results", (token, _options, _cm, pos) => {
          const ResponseTooltip = responseTooltipRef.current;
          const infoElements = [ResponseTooltip && /* @__PURE__ */ jsx(ResponseTooltip, { pos, token }), ImagePreview.shouldRender(token) && /* @__PURE__ */ jsx(ImagePreview, { token }, "image-preview")].filter(_temp);
          if (infoElements.length) {
            tooltipRoot.render(infoElements);
            return tooltipContainer;
          }
          tooltipRoot.unmount();
        });
        const container = ref.current;
        if (!container) {
          return;
        }
        const newEditor = CodeMirror(container, {
          value: initialResponse,
          lineWrapping: true,
          readOnly: true,
          theme: editorTheme,
          mode: "graphql-results",
          foldGutter: true,
          gutters: ["CodeMirror-foldgutter"],
          info: true,
          extraKeys: commonKeys
        });
        setResponseEditor(newEditor);
      });
      return () => {
        isActive = false;
      };
    };
    t9 = [editorTheme, initialResponse, setResponseEditor];
    $[7] = editorTheme;
    $[8] = initialResponse;
    $[9] = setResponseEditor;
    $[10] = t8;
    $[11] = t9;
  } else {
    t8 = $[10];
    t9 = $[11];
  }
  useEffect(t8, t9);
  useSynchronizeOption(responseEditor, "keyMap", keyMap);
  let t10;
  let t11;
  if ($[12] !== fetchError || $[13] !== responseEditor || $[14] !== validationErrors) {
    t10 = () => {
      if (fetchError) {
        responseEditor == null ? void 0 : responseEditor.setValue(fetchError);
      }
      if (validationErrors.length) {
        responseEditor == null ? void 0 : responseEditor.setValue(formatError(validationErrors));
      }
    };
    t11 = [responseEditor, fetchError, validationErrors];
    $[12] = fetchError;
    $[13] = responseEditor;
    $[14] = validationErrors;
    $[15] = t10;
    $[16] = t11;
  } else {
    t10 = $[15];
    t11 = $[16];
  }
  useEffect(t10, t11);
  return ref;
}
function _temp(v) {
  return Boolean(v);
}
export {
  useResponseEditor
};
//# sourceMappingURL=response-editor.js.map
