const invalidCharacters = Array.from({
  length: 11
}, (_, i) => {
  return String.fromCharCode(8192 + i);
}).concat(["\u2028", "\u2029", " ", " "]);
const sanitizeRegex = new RegExp("[" + invalidCharacters.join("") + "]", "g");
function normalizeWhitespace(line) {
  return line.replace(sanitizeRegex, " ");
}
export {
  invalidCharacters,
  normalizeWhitespace
};
//# sourceMappingURL=whitespace.js.map
