import { c } from "react-compiler-runtime";
import { useEffect } from "react";
import { createStore } from "zustand";
import { createBoundedUseStore } from "./utility/create-bounded-use-store.js";
const pluginStore = createStore((set, get) => ({
  plugins: [],
  visiblePlugin: null,
  referencePlugin: void 0,
  setVisiblePlugin(plugin) {
    const {
      plugins,
      onTogglePluginVisibility
    } = get();
    const byTitle = typeof plugin === "string";
    const newVisiblePlugin = plugin && plugins.find((p) => (byTitle ? p.title : p) === plugin) || null;
    set(({
      visiblePlugin
    }) => {
      if (newVisiblePlugin === visiblePlugin) {
        return {
          visiblePlugin
        };
      }
      onTogglePluginVisibility == null ? void 0 : onTogglePluginVisibility(newVisiblePlugin);
      return {
        visiblePlugin: newVisiblePlugin
      };
    });
  }
}));
const PluginContextProvider = (t0) => {
  const $ = c(8);
  const {
    onTogglePluginVisibility,
    children,
    visiblePlugin,
    plugins: t1,
    referencePlugin
  } = t0;
  let t2;
  if ($[0] !== t1) {
    t2 = t1 === void 0 ? [] : t1;
    $[0] = t1;
    $[1] = t2;
  } else {
    t2 = $[1];
  }
  const plugins = t2;
  let t3;
  let t4;
  if ($[2] !== onTogglePluginVisibility || $[3] !== plugins || $[4] !== referencePlugin || $[5] !== visiblePlugin) {
    t3 = () => {
      const seenTitles = /* @__PURE__ */ new Set();
      for (const {
        title
      } of plugins) {
        if (typeof title !== "string" || !title) {
          throw new Error("All GraphiQL plugins must have a unique title");
        }
        if (seenTitles.has(title)) {
          throw new Error(`${"All GraphiQL plugins must have a unique title"}, found two plugins with the title '${title}'`);
        }
        seenTitles.add(title);
      }
      pluginStore.setState({
        plugins,
        onTogglePluginVisibility,
        referencePlugin
      });
      pluginStore.getState().setVisiblePlugin(visiblePlugin ?? null);
    };
    t4 = [plugins, onTogglePluginVisibility, referencePlugin, visiblePlugin];
    $[2] = onTogglePluginVisibility;
    $[3] = plugins;
    $[4] = referencePlugin;
    $[5] = visiblePlugin;
    $[6] = t3;
    $[7] = t4;
  } else {
    t3 = $[6];
    t4 = $[7];
  }
  useEffect(t3, t4);
  return children;
};
const usePluginStore = createBoundedUseStore(pluginStore);
export {
  PluginContextProvider,
  pluginStore,
  usePluginStore
};
//# sourceMappingURL=plugin.js.map
