import { c } from "react-compiler-runtime";
import { fetcherReturnToPromise, isPromise, formatResult, formatError } from "@graphiql/toolkit";
import { buildClientSchema, getIntrospectionQuery, isSchema, validateSchema } from "graphql";
import { useEffect } from "react";
import { createStore } from "zustand";
import { createBoundedUseStore } from "./utility/create-bounded-use-store.js";
import { useEditorContext } from "./editor/context.js";
const schemaStore = createStore((set, get) => ({
  inputValueDeprecation: null,
  introspectionQueryName: null,
  schemaDescription: null,
  fetcher: null,
  // Explicitly set to null, as it's safe since we have TypeError thrown
  onSchemaChange: void 0,
  fetchError: null,
  isFetching: false,
  schema: null,
  /**
   * Derive validation errors from the schema
   */
  validationErrors: [],
  schemaReference: null,
  setSchemaReference(schemaReference) {
    set({
      schemaReference
    });
  },
  requestCounter: 0,
  shouldIntrospect: true,
  /**
   * Fetch the schema
   */
  async introspect() {
    const {
      requestCounter,
      fetcher,
      onSchemaChange,
      shouldIntrospect,
      // @ts-expect-error -- temporally until v 5
      headerEditor,
      ...rest
    } = get();
    if (!shouldIntrospect) {
      return;
    }
    const counter = requestCounter + 1;
    set({
      requestCounter: counter
    });
    try {
      const currentHeaders = headerEditor == null ? void 0 : headerEditor.getValue();
      const parsedHeaders = parseHeaderString(currentHeaders);
      if (!parsedHeaders.isValidJSON) {
        set({
          fetchError: "Introspection failed as headers are invalid."
        });
        return;
      }
      const fetcherOpts = parsedHeaders.headers ? {
        headers: parsedHeaders.headers
      } : {};
      const {
        introspectionQuery,
        introspectionQueryName,
        introspectionQuerySansSubscriptions
      } = generateIntrospectionQuery(rest);
      const fetch = fetcherReturnToPromise(fetcher({
        query: introspectionQuery,
        operationName: introspectionQueryName
      }, fetcherOpts));
      if (!isPromise(fetch)) {
        set({
          fetchError: "Fetcher did not return a Promise for introspection."
        });
        return;
      }
      set({
        isFetching: true,
        fetchError: null
      });
      let result = await fetch;
      if (typeof result !== "object" || result === null || !("data" in result)) {
        const fetch2 = fetcherReturnToPromise(fetcher({
          query: introspectionQuerySansSubscriptions,
          operationName: introspectionQueryName
        }, fetcherOpts));
        if (!isPromise(fetch2)) {
          throw new Error("Fetcher did not return a Promise for introspection.");
        }
        result = await fetch2;
      }
      set({
        isFetching: false
      });
      let introspectionData;
      if ((result == null ? void 0 : result.data) && "__schema" in result.data) {
        introspectionData = result.data;
      } else {
        const responseString = typeof result === "string" ? result : formatResult(result);
        set({
          fetchError: responseString
        });
      }
      if (counter !== get().requestCounter || !introspectionData) {
        return;
      }
      const newSchema = buildClientSchema(introspectionData);
      set({
        schema: newSchema
      });
      onSchemaChange == null ? void 0 : onSchemaChange(newSchema);
    } catch (error) {
      if (counter !== get().requestCounter) {
        return;
      }
      set({
        fetchError: formatError(error),
        isFetching: false
      });
    }
  }
}));
const SchemaContextProvider = (t0) => {
  const $ = c(14);
  const {
    fetcher,
    onSchemaChange,
    dangerouslyAssumeSchemaIsValid: t1,
    children,
    schema,
    inputValueDeprecation: t2,
    introspectionQueryName: t3,
    schemaDescription: t4
  } = t0;
  const dangerouslyAssumeSchemaIsValid = t1 === void 0 ? false : t1;
  const inputValueDeprecation = t2 === void 0 ? false : t2;
  const introspectionQueryName = t3 === void 0 ? "IntrospectionQuery" : t3;
  const schemaDescription = t4 === void 0 ? false : t4;
  if (!fetcher) {
    throw new TypeError("The `SchemaContextProvider` component requires a `fetcher` function to be passed as prop.");
  }
  let t5;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t5 = {
      nonNull: true,
      caller: SchemaContextProvider
    };
    $[0] = t5;
  } else {
    t5 = $[0];
  }
  const {
    headerEditor
  } = useEditorContext(t5);
  let t6;
  let t7;
  if ($[1] !== headerEditor) {
    t6 = () => {
      if (headerEditor) {
        schemaStore.setState({
          headerEditor
        });
      }
    };
    t7 = [headerEditor];
    $[1] = headerEditor;
    $[2] = t6;
    $[3] = t7;
  } else {
    t6 = $[2];
    t7 = $[3];
  }
  useEffect(t6, t7);
  let t8;
  let t9;
  if ($[4] !== dangerouslyAssumeSchemaIsValid || $[5] !== fetcher || $[6] !== inputValueDeprecation || $[7] !== introspectionQueryName || $[8] !== onSchemaChange || $[9] !== schema || $[10] !== schemaDescription) {
    t8 = () => {
      const newSchema = isSchema(schema) || schema == null ? schema : void 0;
      const validationErrors = !newSchema || dangerouslyAssumeSchemaIsValid ? [] : validateSchema(newSchema);
      schemaStore.setState((t102) => {
        const {
          requestCounter
        } = t102;
        return {
          fetcher,
          onSchemaChange,
          schema: newSchema,
          shouldIntrospect: !isSchema(schema) && schema !== null,
          inputValueDeprecation,
          introspectionQueryName,
          schemaDescription,
          validationErrors,
          requestCounter: requestCounter + 1
        };
      });
      schemaStore.getState().introspect();
    };
    t9 = [schema, dangerouslyAssumeSchemaIsValid, onSchemaChange, fetcher, inputValueDeprecation, introspectionQueryName, schemaDescription];
    $[4] = dangerouslyAssumeSchemaIsValid;
    $[5] = fetcher;
    $[6] = inputValueDeprecation;
    $[7] = introspectionQueryName;
    $[8] = onSchemaChange;
    $[9] = schema;
    $[10] = schemaDescription;
    $[11] = t8;
    $[12] = t9;
  } else {
    t8 = $[11];
    t9 = $[12];
  }
  useEffect(t8, t9);
  let t10;
  if ($[13] === Symbol.for("react.memo_cache_sentinel")) {
    t10 = [];
    $[13] = t10;
  } else {
    t10 = $[13];
  }
  useEffect(_temp, t10);
  return children;
};
const useSchemaStore = createBoundedUseStore(schemaStore);
function generateIntrospectionQuery({
  inputValueDeprecation,
  introspectionQueryName,
  schemaDescription
}) {
  const query = getIntrospectionQuery({
    inputValueDeprecation,
    schemaDescription
  });
  const introspectionQuery = introspectionQueryName === "IntrospectionQuery" ? query : query.replace("query IntrospectionQuery", `query ${introspectionQueryName}`);
  const introspectionQuerySansSubscriptions = query.replace("subscriptionType { name }", "");
  return {
    introspectionQueryName,
    introspectionQuery,
    introspectionQuerySansSubscriptions
  };
}
function parseHeaderString(headersString) {
  let headers = null;
  let isValidJSON = true;
  try {
    if (headersString) {
      headers = JSON.parse(headersString);
    }
  } catch {
    isValidJSON = false;
  }
  return {
    headers,
    isValidJSON
  };
}
function _temp() {
  const triggerIntrospection = function triggerIntrospection2(event) {
    if (event.ctrlKey && event.key === "R") {
      schemaStore.getState().introspect();
    }
  };
  window.addEventListener("keydown", triggerIntrospection);
  return () => {
    window.removeEventListener("keydown", triggerIntrospection);
  };
}
export {
  SchemaContextProvider,
  schemaStore,
  useSchemaStore
};
//# sourceMappingURL=schema.js.map
