import { Storage, StorageAPI } from '@graphiql/toolkit';
import { FC, ReactNode } from 'react';
declare type StorageContextType = {
    storage: StorageAPI;
};
declare type StorageContextProviderProps = {
    children: ReactNode;
    /**
     * Provide a custom storage API.
     * @default localStorage
     * @see {@link https://graphiql-test.netlify.app/typedoc/modules/graphiql_toolkit.html#storage-2|API docs}
     * for details on the required interface.
     */
    storage?: Storage;
};
export declare const storageStore: import('zustand').StoreApi<StorageContextType>;
export declare const StorageContextProvider: FC<StorageContextProviderProps>;
export declare const useStorage: () => StorageAPI;
export {};
