import { c } from "react-compiler-runtime";
import { StorageAPI } from "@graphiql/toolkit";
import { useEffect } from "react";
import { createStore } from "zustand";
import { createBoundedUseStore } from "./utility/create-bounded-use-store.js";
const storageStore = createStore(() => ({
  storage: null
}));
const StorageContextProvider = (t0) => {
  const $ = c(3);
  const {
    storage,
    children
  } = t0;
  const isMounted = useStorageStore(_temp);
  let t1;
  let t2;
  if ($[0] !== storage) {
    t1 = () => {
      storageStore.setState({
        storage: new StorageAPI(storage)
      });
    };
    t2 = [storage];
    $[0] = storage;
    $[1] = t1;
    $[2] = t2;
  } else {
    t1 = $[1];
    t2 = $[2];
  }
  useEffect(t1, t2);
  if (!isMounted) {
    return null;
  }
  return children;
};
const useStorageStore = createBoundedUseStore(storageStore);
const useStorage = () => {
  return useStorageStore(_temp2);
};
function _temp(store) {
  return Boolean(store.storage);
}
function _temp2(store) {
  return store.storage;
}
export {
  StorageContextProvider,
  storageStore,
  useStorage
};
//# sourceMappingURL=storage.js.map
