import { c } from "react-compiler-runtime";
import { useState, useRef, useEffect } from "react";
import { useStorage } from "../storage.js";
import { debounce } from "./debounce.js";
function useDragResize(t0) {
  const $ = c(31);
  const {
    defaultSizeRelation: t1,
    direction,
    initiallyHidden,
    onHiddenElementChange,
    sizeThresholdFirst: t2,
    sizeThresholdSecond: t3,
    storageKey
  } = t0;
  const defaultSizeRelation = t1 === void 0 ? 1 : t1;
  const sizeThresholdFirst = t2 === void 0 ? 100 : t2;
  const sizeThresholdSecond = t3 === void 0 ? 100 : t3;
  const storage = useStorage();
  let t4;
  if ($[0] !== storage || $[1] !== storageKey) {
    t4 = debounce(500, (value) => {
      if (storageKey) {
        storage.set(storageKey, value);
      }
    });
    $[0] = storage;
    $[1] = storageKey;
    $[2] = t4;
  } else {
    t4 = $[2];
  }
  const store = t4;
  let t5;
  if ($[3] !== initiallyHidden || $[4] !== storage || $[5] !== storageKey) {
    t5 = () => {
      const storedValue = storageKey && storage.get(storageKey);
      if (storedValue === HIDE_FIRST || initiallyHidden === "first") {
        return "first";
      }
      if (storedValue === HIDE_SECOND || initiallyHidden === "second") {
        return "second";
      }
      return null;
    };
    $[3] = initiallyHidden;
    $[4] = storage;
    $[5] = storageKey;
    $[6] = t5;
  } else {
    t5 = $[6];
  }
  const [hiddenElement, setHiddenElement] = useState(t5);
  let t6;
  if ($[7] !== hiddenElement || $[8] !== onHiddenElementChange) {
    t6 = (element) => {
      if (element !== hiddenElement) {
        setHiddenElement(element);
        onHiddenElementChange == null ? void 0 : onHiddenElementChange(element);
      }
    };
    $[7] = hiddenElement;
    $[8] = onHiddenElementChange;
    $[9] = t6;
  } else {
    t6 = $[9];
  }
  const setHiddenElementWithCallback = t6;
  const firstRef = useRef(null);
  const dragBarRef = useRef(null);
  const secondRef = useRef(null);
  const defaultFlexRef = useRef(`${defaultSizeRelation}`);
  let t7;
  if ($[10] !== storage || $[11] !== storageKey) {
    t7 = () => {
      const storedValue_0 = storageKey && storage.get(storageKey) || defaultFlexRef.current;
      if (firstRef.current) {
        firstRef.current.style.flex = storedValue_0 === HIDE_FIRST || storedValue_0 === HIDE_SECOND ? defaultFlexRef.current : storedValue_0;
      }
      if (secondRef.current) {
        secondRef.current.style.flex = "1";
      }
    };
    $[10] = storage;
    $[11] = storageKey;
    $[12] = t7;
  } else {
    t7 = $[12];
  }
  let t8;
  if ($[13] !== direction || $[14] !== storage || $[15] !== storageKey) {
    t8 = [direction, storage, storageKey];
    $[13] = direction;
    $[14] = storage;
    $[15] = storageKey;
    $[16] = t8;
  } else {
    t8 = $[16];
  }
  useEffect(t7, t8);
  let t10;
  let t9;
  if ($[17] !== hiddenElement || $[18] !== storage || $[19] !== storageKey) {
    t9 = () => {
      const hide = (resizableElement) => {
        const element_0 = resizableElement === "first" ? firstRef.current : secondRef.current;
        if (!element_0) {
          return;
        }
        element_0.style.left = "-1000px";
        element_0.style.position = "absolute";
        element_0.style.opacity = "0";
        element_0.style.height = "500px";
        element_0.style.width = "500px";
        if (firstRef.current) {
          const flex = parseFloat(firstRef.current.style.flex);
          if (!Number.isFinite(flex) || flex < 1) {
            firstRef.current.style.flex = "1";
          }
        }
      };
      const show = (resizableElement_0) => {
        const element_1 = resizableElement_0 === "first" ? firstRef.current : secondRef.current;
        if (!element_1) {
          return;
        }
        element_1.style.width = "";
        element_1.style.height = "";
        element_1.style.opacity = "";
        element_1.style.position = "";
        element_1.style.left = "";
        if (storageKey) {
          const storedValue_1 = storage.get(storageKey);
          if (firstRef.current && storedValue_1 !== HIDE_FIRST && storedValue_1 !== HIDE_SECOND) {
            firstRef.current.style.flex = storedValue_1 || defaultFlexRef.current;
          }
        }
      };
      if (hiddenElement === "first") {
        hide("first");
      } else {
        show("first");
      }
      if (hiddenElement === "second") {
        hide("second");
      } else {
        show("second");
      }
    };
    t10 = [hiddenElement, storage, storageKey];
    $[17] = hiddenElement;
    $[18] = storage;
    $[19] = storageKey;
    $[20] = t10;
    $[21] = t9;
  } else {
    t10 = $[20];
    t9 = $[21];
  }
  useEffect(t9, t10);
  let t11;
  let t12;
  if ($[22] !== direction || $[23] !== setHiddenElementWithCallback || $[24] !== sizeThresholdFirst || $[25] !== sizeThresholdSecond || $[26] !== store) {
    t11 = () => {
      if (!dragBarRef.current || !firstRef.current || !secondRef.current) {
        return;
      }
      const dragBarContainer = dragBarRef.current;
      const firstContainer = firstRef.current;
      const wrapper = firstContainer.parentElement;
      const eventProperty = direction === "horizontal" ? "clientX" : "clientY";
      const rectProperty = direction === "horizontal" ? "left" : "top";
      const adjacentRectProperty = direction === "horizontal" ? "right" : "bottom";
      const sizeProperty = direction === "horizontal" ? "clientWidth" : "clientHeight";
      const handleMouseDown = function handleMouseDown2(downEvent) {
        const isClickOnCurrentElement = downEvent.target === downEvent.currentTarget;
        if (!isClickOnCurrentElement) {
          return;
        }
        downEvent.preventDefault();
        const offset = downEvent[eventProperty] - dragBarContainer.getBoundingClientRect()[rectProperty];
        const handleMouseMove = function handleMouseMove2(moveEvent) {
          if (moveEvent.buttons === 0) {
            return handleMouseUp();
          }
          const firstSize = moveEvent[eventProperty] - wrapper.getBoundingClientRect()[rectProperty] - offset;
          const secondSize = wrapper.getBoundingClientRect()[adjacentRectProperty] - moveEvent[eventProperty] + offset - dragBarContainer[sizeProperty];
          if (firstSize < sizeThresholdFirst) {
            setHiddenElementWithCallback("first");
            store(HIDE_FIRST);
          } else {
            if (secondSize < sizeThresholdSecond) {
              setHiddenElementWithCallback("second");
              store(HIDE_SECOND);
            } else {
              setHiddenElementWithCallback(null);
              const newFlex = `${firstSize / secondSize}`;
              firstContainer.style.flex = newFlex;
              store(newFlex);
            }
          }
        };
        function handleMouseUp() {
          document.removeEventListener("mousemove", handleMouseMove);
          document.removeEventListener("mouseup", handleMouseUp);
        }
        document.addEventListener("mousemove", handleMouseMove);
        document.addEventListener("mouseup", handleMouseUp);
      };
      dragBarContainer.addEventListener("mousedown", handleMouseDown);
      const reset = function reset2() {
        if (firstRef.current) {
          firstRef.current.style.flex = defaultFlexRef.current;
        }
        store(defaultFlexRef.current);
        setHiddenElementWithCallback(null);
      };
      dragBarContainer.addEventListener("dblclick", reset);
      return () => {
        dragBarContainer.removeEventListener("mousedown", handleMouseDown);
        dragBarContainer.removeEventListener("dblclick", reset);
      };
    };
    t12 = [direction, setHiddenElementWithCallback, sizeThresholdFirst, sizeThresholdSecond, store];
    $[22] = direction;
    $[23] = setHiddenElementWithCallback;
    $[24] = sizeThresholdFirst;
    $[25] = sizeThresholdSecond;
    $[26] = store;
    $[27] = t11;
    $[28] = t12;
  } else {
    t11 = $[27];
    t12 = $[28];
  }
  useEffect(t11, t12);
  let t13;
  if ($[29] !== hiddenElement) {
    t13 = {
      dragBarRef,
      hiddenElement,
      firstRef,
      setHiddenElement,
      secondRef
    };
    $[29] = hiddenElement;
    $[30] = t13;
  } else {
    t13 = $[30];
  }
  return t13;
}
const HIDE_FIRST = "hide-first";
const HIDE_SECOND = "hide-second";
export {
  useDragResize
};
//# sourceMappingURL=resize.js.map
