import { jsx, jsxs } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { forwardRef } from "react";
import { CloseIcon } from "../../icons/index.js";
import { UnStyledButton } from "../button/index.js";
import * as D from "@radix-ui/react-dialog";
import { Root } from "@radix-ui/react-visually-hidden";
/* empty css          */
import { clsx } from "clsx";
const DialogClose = forwardRef((props, ref) => {
  const $ = c(8);
  let t0;
  if ($[0] !== props.className) {
    t0 = clsx("graphiql-dialog-close", props.className);
    $[0] = props.className;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  let t1;
  let t2;
  if ($[2] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = /* @__PURE__ */ jsx(Root, { children: "Close dialog" });
    t2 = /* @__PURE__ */ jsx(CloseIcon, {});
    $[2] = t1;
    $[3] = t2;
  } else {
    t1 = $[2];
    t2 = $[3];
  }
  let t3;
  if ($[4] !== props || $[5] !== ref || $[6] !== t0) {
    t3 = /* @__PURE__ */ jsx(D.Close, { asChild: true, children: /* @__PURE__ */ jsxs(UnStyledButton, { ...props, ref, type: "button", className: t0, children: [
      t1,
      t2
    ] }) });
    $[4] = props;
    $[5] = ref;
    $[6] = t0;
    $[7] = t3;
  } else {
    t3 = $[7];
  }
  return t3;
});
DialogClose.displayName = "Dialog.Close";
const DialogRoot = (t0) => {
  const $ = c(9);
  let children;
  let props;
  if ($[0] !== t0) {
    ({
      children,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = children;
    $[2] = props;
  } else {
    children = $[1];
    props = $[2];
  }
  let t1;
  if ($[3] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = /* @__PURE__ */ jsx(D.Overlay, { className: "graphiql-dialog-overlay" });
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  let t2;
  if ($[4] !== children) {
    t2 = /* @__PURE__ */ jsxs(D.Portal, { children: [
      t1,
      /* @__PURE__ */ jsx(D.Content, { className: "graphiql-dialog", children })
    ] });
    $[4] = children;
    $[5] = t2;
  } else {
    t2 = $[5];
  }
  let t3;
  if ($[6] !== props || $[7] !== t2) {
    t3 = /* @__PURE__ */ jsx(D.Root, { ...props, children: t2 });
    $[6] = props;
    $[7] = t2;
    $[8] = t3;
  } else {
    t3 = $[8];
  }
  return t3;
};
const Dialog = Object.assign(DialogRoot, {
  Close: DialogClose,
  Title: D.Title,
  Trigger: D.Trigger,
  Description: D.Description
});
export {
  Dialog
};
//# sourceMappingURL=index.js.map
