import { jsxs, jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { useGraphiQLActions, useGraphiQL } from "../provider.js";
import { StopIcon, PlayIcon } from "../../icons/index.js";
import { DropdownMenu } from "../dropdown-menu/index.js";
import { Tooltip } from "../tooltip/index.js";
import { formatShortcutForOS, KEY_MAP } from "../../constants.js";
/* empty css          */
import { pick } from "../../utility/pick.js";
const ExecuteButton = () => {
  const $ = c(18);
  const {
    setOperationName,
    run,
    stop
  } = useGraphiQLActions();
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = pick("operations", "operationName", "isFetching", "overrideOperationName");
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const {
    operations: t1,
    operationName,
    isFetching,
    overrideOperationName
  } = useGraphiQL(t0);
  let t2;
  if ($[1] !== t1) {
    t2 = t1 === void 0 ? [] : t1;
    $[1] = t1;
    $[2] = t2;
  } else {
    t2 = $[2];
  }
  const operations = t2;
  const isSubscribed = useGraphiQL(_temp);
  const hasOptions = operations.length > 1 && typeof overrideOperationName !== "string";
  const isRunning = isFetching || isSubscribed;
  const label = `${isRunning ? "Stop" : "Execute"} query (${formatShortcutForOS(KEY_MAP.runQuery.key, "Cmd")})`;
  let t3;
  if ($[3] !== isRunning) {
    t3 = isRunning ? /* @__PURE__ */ jsx(StopIcon, {}) : /* @__PURE__ */ jsx(PlayIcon, {});
    $[3] = isRunning;
    $[4] = t3;
  } else {
    t3 = $[4];
  }
  let t4;
  if ($[5] !== label || $[6] !== t3) {
    t4 = {
      type: "button",
      className: "graphiql-execute-button",
      children: t3,
      "aria-label": label
    };
    $[5] = label;
    $[6] = t3;
    $[7] = t4;
  } else {
    t4 = $[7];
  }
  const buttonProps = t4;
  let t5;
  if ($[8] !== buttonProps || $[9] !== hasOptions || $[10] !== isRunning || $[11] !== label || $[12] !== operationName || $[13] !== operations || $[14] !== run || $[15] !== setOperationName || $[16] !== stop) {
    t5 = hasOptions && !isRunning ? /* @__PURE__ */ jsxs(DropdownMenu, { children: [
      /* @__PURE__ */ jsx(Tooltip, { label, children: /* @__PURE__ */ jsx(DropdownMenu.Button, { ...buttonProps }) }),
      /* @__PURE__ */ jsx(DropdownMenu.Content, { children: operations.map((operation, i) => {
        const opName = operation.name ? operation.name.value : `<Unnamed ${operation.operation}>`;
        return /* @__PURE__ */ jsx(DropdownMenu.Item, { onSelect: () => {
          var _a;
          const selectedOperationName = (_a = operation.name) == null ? void 0 : _a.value;
          if (selectedOperationName && selectedOperationName !== operationName) {
            setOperationName(selectedOperationName);
          }
          run();
        }, children: opName }, `${opName}-${i}`);
      }) })
    ] }) : /* @__PURE__ */ jsx(Tooltip, { label, children: /* @__PURE__ */ jsx("button", { ...buttonProps, onClick: isRunning ? stop : run }) });
    $[8] = buttonProps;
    $[9] = hasOptions;
    $[10] = isRunning;
    $[11] = label;
    $[12] = operationName;
    $[13] = operations;
    $[14] = run;
    $[15] = setOperationName;
    $[16] = stop;
    $[17] = t5;
  } else {
    t5 = $[17];
  }
  return t5;
};
function _temp(state) {
  return Boolean(state.subscription);
}
export {
  ExecuteButton
};
//# sourceMappingURL=index.js.map
