import { jsx, jsxs } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { useState, useRef, useEffect } from "react";
const ImagePreview_ = (t0) => {
  var _a;
  const $ = c(14);
  const {
    path
  } = t0;
  let t1;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = {
      width: null,
      height: null
    };
    $[0] = t1;
  } else {
    t1 = $[0];
  }
  const [t2, setDimensions] = useState(t1);
  const {
    width,
    height
  } = t2;
  const [mime, setMime] = useState(null);
  const ref = useRef(null);
  const src = (_a = pathToURL(path)) == null ? void 0 : _a.href;
  let t3;
  let t4;
  if ($[1] !== src) {
    t3 = () => {
      if (!src) {
        setDimensions({
          width: null,
          height: null
        });
        setMime(null);
        return;
      }
      fetch(src, {
        method: "HEAD"
      }).then((response) => {
        setMime(response.headers.get("Content-Type"));
      }).catch(() => {
        setMime(null);
      });
    };
    t4 = [src];
    $[1] = src;
    $[2] = t3;
    $[3] = t4;
  } else {
    t3 = $[2];
    t4 = $[3];
  }
  useEffect(t3, t4);
  let t5;
  if ($[4] === Symbol.for("react.memo_cache_sentinel")) {
    t5 = () => {
      setDimensions({
        width: ref.current.naturalWidth,
        height: ref.current.naturalHeight
      });
    };
    $[4] = t5;
  } else {
    t5 = $[4];
  }
  let t6;
  if ($[5] !== src) {
    t6 = /* @__PURE__ */ jsx("img", { alt: "", onLoad: t5, ref, src });
    $[5] = src;
    $[6] = t6;
  } else {
    t6 = $[6];
  }
  let t7;
  if ($[7] !== height || $[8] !== mime || $[9] !== width) {
    t7 = width !== null && height !== null && /* @__PURE__ */ jsxs("div", { children: [
      width,
      "x",
      height,
      mime && " " + mime
    ] });
    $[7] = height;
    $[8] = mime;
    $[9] = width;
    $[10] = t7;
  } else {
    t7 = $[10];
  }
  let t8;
  if ($[11] !== t6 || $[12] !== t7) {
    t8 = /* @__PURE__ */ jsxs("div", { children: [
      t6,
      t7
    ] });
    $[11] = t6;
    $[12] = t7;
    $[13] = t8;
  } else {
    t8 = $[13];
  }
  return t8;
};
const ImagePreview = Object.assign(ImagePreview_, {
  shouldRender(path) {
    const url = pathToURL(path);
    return url ? /\.(bmp|gif|jpe?g|png|svg|webp)$/.test(url.pathname) : false;
  }
});
function pathToURL(path) {
  const value = path.slice(1).trim();
  try {
    return new URL(value, location.protocol + "//" + location.host);
  } catch {
  }
}
export {
  ImagePreview
};
//# sourceMappingURL=image-preview.js.map
