import { DocumentNode } from 'graphql';
import { FC } from 'react';
import { EditorProps, SchemaReference } from '../types';
interface OperationEditorProps extends EditorProps {
    /**
     * Invoked when a reference to the GraphQL schema (type or field) is clicked
     * as part of the editor or one of its tooltips.
     * @param reference - The reference that has been clicked.
     */
    onClickReference?(reference: SchemaReference): void;
    /**
     * Invoked when the contents of the operation editor change.
     * @param value - The new contents of the editor.
     * @param documentAST - The editor contents parsed into a GraphQL document.
     */
    onEdit?(value: string, documentAST?: DocumentNode): void;
}
export declare const OperationEditor: FC<OperationEditorProps>;
export {};
