import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { getSelectedOperationName } from "@graphiql/toolkit";
import { getOperationFacts } from "graphql-language-service";
import { useRef, useEffect } from "react";
import { useGraphiQLActions, useGraphiQL } from "./provider.js";
import { URI_NAME, MONACO_GRAPHQL_DIAGNOSTIC_SETTINGS, MONACO_GRAPHQL_API, KEY_BINDINGS, STORAGE_KEY } from "../constants.js";
import * as monacoEditor from "../monaco-editor.js";
import { getContextAtPosition } from "graphql-language-service/esm/parser";
import { toGraphQLPosition } from "monaco-graphql/esm/utils";
import { useStorage } from "../stores/storage.js";
import { onEditorContainerKeyDown, getOrCreateModel, createEditor } from "../utility/create-editor.js";
import { pick } from "../utility/pick.js";
import { debounce } from "../utility/debounce.js";
import { cleanupDisposables } from "../utility/cleanup-disposables.js";
import { clsx } from "clsx";
import { Uri, languages, Range } from "monaco-editor";
const OperationEditor = (t0) => {
  const $ = c(46);
  let onClickReference;
  let onEdit;
  let props;
  if ($[0] !== t0) {
    ({
      onClickReference,
      onEdit,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = onClickReference;
    $[2] = onEdit;
    $[3] = props;
  } else {
    onClickReference = $[1];
    onEdit = $[2];
    props = $[3];
  }
  const {
    setOperationName,
    setEditor,
    updateActiveTabValues,
    setVisiblePlugin,
    setSchemaReference,
    run,
    setOperationFacts,
    copyQuery,
    prettifyEditors,
    mergeQuery
  } = useGraphiQLActions();
  let t1;
  if ($[4] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = pick("initialQuery", "schema", "referencePlugin", "operations", "operationName", "externalFragments", "uriInstanceId");
    $[4] = t1;
  } else {
    t1 = $[4];
  }
  const {
    initialQuery,
    schema,
    referencePlugin,
    operations,
    operationName,
    externalFragments,
    uriInstanceId
  } = useGraphiQL(t1);
  const storage = useStorage();
  const ref = useRef(null);
  const onClickReferenceRef = useRef(null);
  let t2;
  let t3;
  if ($[5] !== onClickReference) {
    t2 = () => {
      onClickReferenceRef.current = onClickReference;
    };
    t3 = [onClickReference];
    $[5] = onClickReference;
    $[6] = t2;
    $[7] = t3;
  } else {
    t2 = $[6];
    t3 = $[7];
  }
  useEffect(t2, t3);
  let t4;
  if ($[8] !== operationName || $[9] !== operations || $[10] !== schema || $[11] !== setOperationFacts) {
    t4 = function getAndUpdateOperationFacts2(editorInstance) {
      const operationFacts = getOperationFacts(schema, editorInstance.getValue());
      const newOperationName = getSelectedOperationName(operations, operationName, operationFacts == null ? void 0 : operationFacts.operations);
      setOperationFacts({
        documentAST: operationFacts == null ? void 0 : operationFacts.documentAST,
        operationName: newOperationName,
        operations: operationFacts == null ? void 0 : operationFacts.operations
      });
      return operationFacts ? {
        ...operationFacts,
        operationName: newOperationName
      } : null;
    };
    $[8] = operationName;
    $[9] = operations;
    $[10] = schema;
    $[11] = setOperationFacts;
    $[12] = t4;
  } else {
    t4 = $[12];
  }
  const getAndUpdateOperationFacts = t4;
  const runAtCursorRef = useRef(null);
  let t5;
  let t6;
  if ($[13] !== operationName || $[14] !== operations || $[15] !== run || $[16] !== setOperationName) {
    t5 = () => {
      runAtCursorRef.current = (editor) => {
        var _a;
        if (!operations) {
          run();
          return;
        }
        const position = editor.getPosition();
        const cursorIndex = editor.getModel().getOffsetAt(position);
        let newOperationName_0;
        for (const operation of operations) {
          if (operation.loc && operation.loc.start <= cursorIndex && operation.loc.end >= cursorIndex) {
            newOperationName_0 = (_a = operation.name) == null ? void 0 : _a.value;
          }
        }
        if (newOperationName_0 && newOperationName_0 !== operationName) {
          setOperationName(newOperationName_0);
        }
        run();
      };
    };
    t6 = [operationName, operations, run, setOperationName];
    $[13] = operationName;
    $[14] = operations;
    $[15] = run;
    $[16] = setOperationName;
    $[17] = t5;
    $[18] = t6;
  } else {
    t5 = $[17];
    t6 = $[18];
  }
  useEffect(t5, t6);
  let t7;
  if ($[19] !== copyQuery || $[20] !== getAndUpdateOperationFacts || $[21] !== initialQuery || $[22] !== mergeQuery || $[23] !== onEdit || $[24] !== operationName || $[25] !== prettifyEditors || $[26] !== setEditor || $[27] !== setOperationName || $[28] !== storage || $[29] !== updateActiveTabValues || $[30] !== uriInstanceId) {
    t7 = () => {
      const operationUri = Uri.file(`${uriInstanceId}${URI_NAME.operation}`);
      const variablesUri = Uri.file(`${uriInstanceId}${URI_NAME.variables}`);
      const {
        validateVariablesJSON
      } = MONACO_GRAPHQL_DIAGNOSTIC_SETTINGS;
      validateVariablesJSON[operationUri.toString()] = [variablesUri.toString()];
      MONACO_GRAPHQL_API.setDiagnosticSettings(MONACO_GRAPHQL_DIAGNOSTIC_SETTINGS);
      globalThis.__MONACO = monacoEditor;
      const model = getOrCreateModel({
        uri: operationUri.path.replace("/", ""),
        value: initialQuery
      });
      const editor_0 = createEditor(ref, {
        model
      });
      setEditor({
        queryEditor: editor_0
      });
      const handleChange = debounce(100, () => {
        const query = editor_0.getValue();
        storage.set(STORAGE_KEY.query, query);
        const operationFacts_0 = getAndUpdateOperationFacts(editor_0);
        onEdit == null ? void 0 : onEdit(query, operationFacts_0 == null ? void 0 : operationFacts_0.documentAST);
        if ((operationFacts_0 == null ? void 0 : operationFacts_0.operationName) && operationName !== operationFacts_0.operationName) {
          setOperationName(operationFacts_0.operationName);
        }
        updateActiveTabValues({
          query,
          operationName: (operationFacts_0 == null ? void 0 : operationFacts_0.operationName) ?? null
        });
      });
      getAndUpdateOperationFacts(editor_0);
      const disposables = [model.onDidChangeContent(handleChange), editor_0.addAction({
        ...KEY_BINDINGS.runQuery,
        run: (...t82) => {
          const args = t82;
          return runAtCursorRef.current(...args);
        }
      }), editor_0.addAction({
        ...KEY_BINDINGS.copyQuery,
        run: copyQuery
      }), editor_0.addAction({
        ...KEY_BINDINGS.prettify,
        run: prettifyEditors
      }), editor_0.addAction({
        ...KEY_BINDINGS.mergeFragments,
        run: mergeQuery
      }), editor_0, model];
      return cleanupDisposables(disposables);
    };
    $[19] = copyQuery;
    $[20] = getAndUpdateOperationFacts;
    $[21] = initialQuery;
    $[22] = mergeQuery;
    $[23] = onEdit;
    $[24] = operationName;
    $[25] = prettifyEditors;
    $[26] = setEditor;
    $[27] = setOperationName;
    $[28] = storage;
    $[29] = updateActiveTabValues;
    $[30] = uriInstanceId;
    $[31] = t7;
  } else {
    t7 = $[31];
  }
  let t8;
  if ($[32] === Symbol.for("react.memo_cache_sentinel")) {
    t8 = [];
    $[32] = t8;
  } else {
    t8 = $[32];
  }
  useEffect(t7, t8);
  let t10;
  let t9;
  if ($[33] !== externalFragments || $[34] !== referencePlugin || $[35] !== schema || $[36] !== setSchemaReference || $[37] !== setVisiblePlugin || $[38] !== uriInstanceId) {
    t9 = () => {
      if (!schema) {
        return;
      }
      MONACO_GRAPHQL_API.setSchemaConfig([{
        uri: `${uriInstanceId}${URI_NAME.schema}`,
        schema
      }]);
      MONACO_GRAPHQL_API.setExternalFragmentDefinitions([...externalFragments.values()]);
      if (!referencePlugin) {
        return;
      }
      let currentSchemaReference;
      currentSchemaReference = null;
      const disposables_0 = [languages.registerDefinitionProvider("graphql", {
        provideDefinition(model_0, position_0, _token) {
          const graphQLPosition = toGraphQLPosition(position_0);
          const context = getContextAtPosition(model_0.getValue(), graphQLPosition, schema);
          if (!context) {
            return;
          }
          const {
            typeInfo,
            token
          } = context;
          const {
            kind,
            step
          } = token.state;
          if (kind === "Field" && step === 0 && typeInfo.fieldDef || kind === "AliasedField" && step === 2 && typeInfo.fieldDef || kind === "ObjectField" && step === 0 && typeInfo.fieldDef || kind === "Directive" && step === 1 && typeInfo.directiveDef || kind === "Variable" && typeInfo.type || kind === "Argument" && step === 0 && typeInfo.argDef || kind === "EnumValue" && typeInfo.enumValue && "description" in typeInfo.enumValue || kind === "NamedType" && typeInfo.type && "description" in typeInfo.type) {
            currentSchemaReference = {
              kind,
              typeInfo
            };
            const {
              lineNumber,
              column
            } = position_0;
            const range = new Range(lineNumber, column, lineNumber, column);
            return [{
              uri: model_0.uri,
              range
            }];
          }
          currentSchemaReference = null;
        }
      }), languages.registerReferenceProvider("graphql", {
        provideReferences(model_1, t112, _context, _token_0) {
          var _a;
          const {
            lineNumber: lineNumber_0,
            column: column_0
          } = t112;
          if (!currentSchemaReference) {
            return;
          }
          setVisiblePlugin(referencePlugin);
          setSchemaReference(currentSchemaReference);
          (_a = onClickReferenceRef.current) == null ? void 0 : _a.call(onClickReferenceRef, currentSchemaReference);
          const range_0 = new Range(lineNumber_0, column_0, lineNumber_0, column_0);
          return [{
            uri: model_1.uri,
            range: range_0
          }];
        }
      })];
      return cleanupDisposables(disposables_0);
    };
    t10 = [schema, referencePlugin, setSchemaReference, setVisiblePlugin, externalFragments, uriInstanceId];
    $[33] = externalFragments;
    $[34] = referencePlugin;
    $[35] = schema;
    $[36] = setSchemaReference;
    $[37] = setVisiblePlugin;
    $[38] = uriInstanceId;
    $[39] = t10;
    $[40] = t9;
  } else {
    t10 = $[39];
    t9 = $[40];
  }
  useEffect(t9, t10);
  let t11;
  if ($[41] !== props.className) {
    t11 = clsx("graphiql-editor", props.className);
    $[41] = props.className;
    $[42] = t11;
  } else {
    t11 = $[42];
  }
  let t12;
  if ($[43] !== props || $[44] !== t11) {
    t12 = /* @__PURE__ */ jsx("div", { ref, tabIndex: 0, onKeyDown: onEditorContainerKeyDown, ...props, className: t11 });
    $[43] = props;
    $[44] = t11;
    $[45] = t12;
  } else {
    t12 = $[45];
  }
  return t12;
};
export {
  OperationEditor
};
//# sourceMappingURL=operation-editor.js.map
