import { ComponentPropsWithoutRef, FC, ReactNode } from 'react';
import { EditorProps, ExecutionProps, PluginProps, SchemaProps } from '../stores';
import { StorageStore } from '../stores/storage';
import { ThemeStore } from '../stores/theme';
import { SlicesWithActions } from '../types';
interface InnerGraphiQLProviderProps extends EditorProps, ExecutionProps, PluginProps, SchemaProps {
    children: ReactNode;
}
declare type GraphiQLProviderProps = InnerGraphiQLProviderProps & ComponentPropsWithoutRef<typeof StorageStore> & ComponentPropsWithoutRef<typeof ThemeStore>;
export declare const GraphiQLProvider: FC<GraphiQLProviderProps>;
export declare function useGraphiQL<T>(selector: (state: SlicesWithActions) => T): T;
/**
 * Actions are functions used to update values in your store. They are static and never change.
 * @see https://tkdodo.eu/blog/working-with-zustand#separate-actions-from-state
 */
export declare const useGraphiQLActions: () => import('../types').AllActions;
export {};
