import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { useContext, createContext, useRef, useId, useEffect } from "react";
import { useStore, create } from "zustand";
import { useShallow } from "zustand/shallow";
import { useStorage, StorageStore } from "../stores/storage.js";
import { ThemeStore } from "../stores/theme.js";
import { isSchema, validateSchema, visit, parse } from "graphql";
import { DEFAULT_QUERY, DEFAULT_PRETTIFY_QUERY, JSON_DIAGNOSTIC_OPTIONS, STORAGE_KEY } from "../constants.js";
import { getDefaultTabState } from "../utility/tabs.js";
import { useDidUpdate } from "../utility/hooks.js";
import { createEditorSlice } from "../stores/editor.js";
import { createExecutionSlice } from "../stores/execution.js";
import { createPluginSlice } from "../stores/plugin.js";
import { createSchemaSlice } from "../stores/schema.js";
import { languages } from "monaco-editor";
const GraphiQLContext = createContext(null);
const GraphiQLProvider = (t0) => {
  const $ = c(14);
  let defaultTheme;
  let editorTheme;
  let props;
  let storage;
  if ($[0] !== t0) {
    ({
      storage,
      defaultTheme,
      editorTheme,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = defaultTheme;
    $[2] = editorTheme;
    $[3] = props;
    $[4] = storage;
  } else {
    defaultTheme = $[1];
    editorTheme = $[2];
    props = $[3];
    storage = $[4];
  }
  if (!props.fetcher) {
    throw new TypeError("The `GraphiQLProvider` component requires a `fetcher` function to be passed as prop.");
  }
  if (props.validationRules) {
    throw new TypeError("The `validationRules` prop has been removed. Use custom GraphQL worker, see https://github.com/graphql/graphiql/tree/main/packages/monaco-graphql#custom-webworker-for-passing-non-static-config-to-worker.");
  }
  if (props.query) {
    throw new TypeError(`The \`query\` prop has been removed. Use \`initialQuery\` prop instead, or set value programmatically using:

const queryEditor = useGraphiQL(state => state.queryEditor)

useEffect(() => {
  queryEditor.setValue(query)
}, [query])`);
  }
  if (props.variables) {
    throw new TypeError(`The \`variables\` prop has been removed. Use \`initialVariables\` prop instead, or set value programmatically using:

const variableEditor = useGraphiQL(state => state.variableEditor)

useEffect(() => {
  variableEditor.setValue(variables)
}, [variables])`);
  }
  if (props.headers) {
    throw new TypeError(`The \`headers\` prop has been removed. Use \`initialHeaders\` prop instead, or set value programmatically using:

const headerEditor = useGraphiQL(state => state.headerEditor)

useEffect(() => {
  headerEditor.setValue(headers)
}, [headers])`);
  }
  if (props.response) {
    throw new TypeError(`The \`response\` prop has been removed. Set value programmatically using:

const responseEditor = useGraphiQL(state => state.responseEditor)

useEffect(() => {
  responseEditor.setValue(response)
}, [response])`);
  }
  let t1;
  if ($[5] !== props) {
    t1 = /* @__PURE__ */ jsx(InnerGraphiQLProvider, { ...props });
    $[5] = props;
    $[6] = t1;
  } else {
    t1 = $[6];
  }
  let t2;
  if ($[7] !== defaultTheme || $[8] !== editorTheme || $[9] !== t1) {
    t2 = /* @__PURE__ */ jsx(ThemeStore, { defaultTheme, editorTheme, children: t1 });
    $[7] = defaultTheme;
    $[8] = editorTheme;
    $[9] = t1;
    $[10] = t2;
  } else {
    t2 = $[10];
  }
  let t3;
  if ($[11] !== storage || $[12] !== t2) {
    t3 = /* @__PURE__ */ jsx(StorageStore, { storage, children: t2 });
    $[11] = storage;
    $[12] = t2;
    $[13] = t3;
  } else {
    t3 = $[13];
  }
  return t3;
};
const InnerGraphiQLProvider = (t0) => {
  const $ = c(78);
  let children;
  let defaultHeaders;
  let defaultTabs;
  let externalFragments;
  let fetcher;
  let getDefaultFieldNames;
  let onCopyQuery;
  let onEditOperationName;
  let onSchemaChange;
  let onTabChange;
  let onTogglePluginVisibility;
  let props;
  let referencePlugin;
  let schema;
  let t1;
  let t2;
  let t3;
  let t4;
  let t5;
  let t6;
  let t7;
  let t8;
  let t9;
  let visiblePlugin;
  if ($[0] !== t0) {
    ({
      defaultHeaders,
      defaultQuery: t1,
      defaultTabs,
      externalFragments,
      onEditOperationName,
      onTabChange,
      shouldPersistHeaders: t2,
      onCopyQuery,
      onPrettifyQuery: t3,
      dangerouslyAssumeSchemaIsValid: t4,
      fetcher,
      inputValueDeprecation: t5,
      introspectionQueryName: t6,
      onSchemaChange,
      schema,
      schemaDescription: t7,
      getDefaultFieldNames,
      operationName: t8,
      onTogglePluginVisibility,
      plugins: t9,
      referencePlugin,
      visiblePlugin,
      children,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = children;
    $[2] = defaultHeaders;
    $[3] = defaultTabs;
    $[4] = externalFragments;
    $[5] = fetcher;
    $[6] = getDefaultFieldNames;
    $[7] = onCopyQuery;
    $[8] = onEditOperationName;
    $[9] = onSchemaChange;
    $[10] = onTabChange;
    $[11] = onTogglePluginVisibility;
    $[12] = props;
    $[13] = referencePlugin;
    $[14] = schema;
    $[15] = t1;
    $[16] = t2;
    $[17] = t3;
    $[18] = t4;
    $[19] = t5;
    $[20] = t6;
    $[21] = t7;
    $[22] = t8;
    $[23] = t9;
    $[24] = visiblePlugin;
  } else {
    children = $[1];
    defaultHeaders = $[2];
    defaultTabs = $[3];
    externalFragments = $[4];
    fetcher = $[5];
    getDefaultFieldNames = $[6];
    onCopyQuery = $[7];
    onEditOperationName = $[8];
    onSchemaChange = $[9];
    onTabChange = $[10];
    onTogglePluginVisibility = $[11];
    props = $[12];
    referencePlugin = $[13];
    schema = $[14];
    t1 = $[15];
    t2 = $[16];
    t3 = $[17];
    t4 = $[18];
    t5 = $[19];
    t6 = $[20];
    t7 = $[21];
    t8 = $[22];
    t9 = $[23];
    visiblePlugin = $[24];
  }
  const defaultQuery = t1 === void 0 ? DEFAULT_QUERY : t1;
  const shouldPersistHeaders = t2 === void 0 ? false : t2;
  const onPrettifyQuery = t3 === void 0 ? DEFAULT_PRETTIFY_QUERY : t3;
  const dangerouslyAssumeSchemaIsValid = t4 === void 0 ? false : t4;
  const inputValueDeprecation = t5 === void 0 ? false : t5;
  const introspectionQueryName = t6 === void 0 ? "IntrospectionQuery" : t6;
  const schemaDescription = t7 === void 0 ? false : t7;
  const operationName = t8 === void 0 ? null : t8;
  let t10;
  if ($[25] !== t9) {
    t10 = t9 === void 0 ? [] : t9;
    $[25] = t9;
    $[26] = t10;
  } else {
    t10 = $[26];
  }
  const plugins = t10;
  const storage = useStorage();
  const storeRef = useRef(null);
  const uriInstanceId = useId();
  if (storeRef.current === null) {
    let t112;
    if ($[27] !== plugins || $[28] !== storage || $[29] !== visiblePlugin) {
      t112 = function getInitialVisiblePlugin2() {
        const storedValue = storage.get(STORAGE_KEY.visiblePlugin);
        const pluginForStoredValue = plugins.find((plugin) => plugin.title === storedValue);
        if (pluginForStoredValue) {
          return pluginForStoredValue;
        }
        if (storedValue) {
          storage.set(STORAGE_KEY.visiblePlugin, "");
        }
        return visiblePlugin;
      };
      $[27] = plugins;
      $[28] = storage;
      $[29] = visiblePlugin;
      $[30] = t112;
    } else {
      t112 = $[30];
    }
    const getInitialVisiblePlugin = t112;
    let t122;
    if ($[31] !== defaultHeaders || $[32] !== defaultQuery || $[33] !== defaultTabs || $[34] !== externalFragments || $[35] !== fetcher || $[36] !== getDefaultFieldNames || $[37] !== getInitialVisiblePlugin || $[38] !== inputValueDeprecation || $[39] !== introspectionQueryName || $[40] !== onCopyQuery || $[41] !== onEditOperationName || $[42] !== onPrettifyQuery || $[43] !== onSchemaChange || $[44] !== onTabChange || $[45] !== onTogglePluginVisibility || $[46] !== operationName || $[47] !== plugins || $[48] !== props.initialHeaders || $[49] !== props.initialQuery || $[50] !== props.initialVariables || $[51] !== referencePlugin || $[52] !== schemaDescription || $[53] !== shouldPersistHeaders || $[54] !== storage || $[55] !== uriInstanceId) {
      t122 = function getInitialState2() {
        const query = props.initialQuery ?? storage.get(STORAGE_KEY.query);
        const variables = props.initialVariables ?? storage.get(STORAGE_KEY.variables);
        const headers = props.initialHeaders ?? storage.get(STORAGE_KEY.headers);
        const {
          tabs,
          activeTabIndex
        } = getDefaultTabState({
          defaultHeaders,
          defaultQuery,
          defaultTabs,
          headers,
          query,
          shouldPersistHeaders,
          variables
        });
        const isStored = storage.get(STORAGE_KEY.persistHeaders) !== null;
        const $shouldPersistHeaders = shouldPersistHeaders !== false && isStored ? storage.get(STORAGE_KEY.persistHeaders) === "true" : shouldPersistHeaders;
        const store = create((...t133) => {
          const args = t133;
          const editorSlice = createEditorSlice({
            activeTabIndex,
            defaultHeaders,
            defaultQuery,
            externalFragments: getExternalFragments(externalFragments),
            initialHeaders: headers ?? defaultHeaders ?? "",
            initialQuery: query ?? (activeTabIndex === 0 ? tabs[0].query : null) ?? "",
            initialVariables: variables ?? "",
            onCopyQuery,
            onEditOperationName,
            onPrettifyQuery,
            onTabChange,
            shouldPersistHeaders: $shouldPersistHeaders,
            tabs,
            uriInstanceId: uriInstanceId.replaceAll(/[:«»]/g, "") + "-"
          })(...args);
          const executionSlice = createExecutionSlice({
            fetcher,
            getDefaultFieldNames,
            overrideOperationName: operationName
          })(...args);
          const pluginSlice = createPluginSlice({
            onTogglePluginVisibility,
            referencePlugin
          })(...args);
          const schemaSlice = createSchemaSlice({
            inputValueDeprecation,
            introspectionQueryName,
            onSchemaChange,
            schemaDescription
          })(...args);
          return {
            ...editorSlice,
            ...executionSlice,
            ...pluginSlice,
            ...schemaSlice,
            actions: {
              ...editorSlice.actions,
              ...executionSlice.actions,
              ...pluginSlice.actions,
              ...schemaSlice.actions
            }
          };
        });
        const {
          actions
        } = store.getState();
        actions.storeTabs({
          activeTabIndex,
          tabs
        });
        actions.setPlugins(plugins);
        const initialVisiblePlugin = getInitialVisiblePlugin();
        actions.setVisiblePlugin(initialVisiblePlugin);
        return store;
      };
      $[31] = defaultHeaders;
      $[32] = defaultQuery;
      $[33] = defaultTabs;
      $[34] = externalFragments;
      $[35] = fetcher;
      $[36] = getDefaultFieldNames;
      $[37] = getInitialVisiblePlugin;
      $[38] = inputValueDeprecation;
      $[39] = introspectionQueryName;
      $[40] = onCopyQuery;
      $[41] = onEditOperationName;
      $[42] = onPrettifyQuery;
      $[43] = onSchemaChange;
      $[44] = onTabChange;
      $[45] = onTogglePluginVisibility;
      $[46] = operationName;
      $[47] = plugins;
      $[48] = props.initialHeaders;
      $[49] = props.initialQuery;
      $[50] = props.initialVariables;
      $[51] = referencePlugin;
      $[52] = schemaDescription;
      $[53] = shouldPersistHeaders;
      $[54] = storage;
      $[55] = uriInstanceId;
      $[56] = t122;
    } else {
      t122 = $[56];
    }
    const getInitialState = t122;
    let t132;
    if ($[57] !== getInitialState) {
      t132 = getInitialState();
      $[57] = getInitialState;
      $[58] = t132;
    } else {
      t132 = $[58];
    }
    storeRef.current = t132;
  }
  let t11;
  let t12;
  if ($[59] !== fetcher) {
    t11 = () => {
      storeRef.current.setState({
        fetcher
      });
    };
    t12 = [fetcher];
    $[59] = fetcher;
    $[60] = t11;
    $[61] = t12;
  } else {
    t11 = $[60];
    t12 = $[61];
  }
  useDidUpdate(t11, t12);
  let t13;
  let t14;
  if ($[62] !== plugins || $[63] !== visiblePlugin) {
    t13 = () => {
      const {
        actions: actions_0
      } = storeRef.current.getState();
      actions_0.setPlugins(plugins);
      actions_0.setVisiblePlugin(visiblePlugin);
    };
    t14 = [plugins, visiblePlugin];
    $[62] = plugins;
    $[63] = visiblePlugin;
    $[64] = t13;
    $[65] = t14;
  } else {
    t13 = $[64];
    t14 = $[65];
  }
  useDidUpdate(t13, t14);
  let t15;
  if ($[66] !== dangerouslyAssumeSchemaIsValid || $[67] !== schema) {
    t15 = () => {
      const newSchema = isSchema(schema) || schema == null ? schema : void 0;
      const validationErrors = !newSchema || dangerouslyAssumeSchemaIsValid ? [] : validateSchema(newSchema);
      const store_0 = storeRef.current;
      store_0.setState((t162) => {
        const {
          requestCounter
        } = t162;
        return {
          requestCounter: requestCounter + 1,
          schema: newSchema,
          shouldIntrospect: !isSchema(schema) && schema !== null,
          validationErrors
        };
      });
      const {
        actions: actions_1
      } = store_0.getState();
      actions_1.introspect();
    };
    $[66] = dangerouslyAssumeSchemaIsValid;
    $[67] = schema;
    $[68] = t15;
  } else {
    t15 = $[68];
  }
  let t16;
  if ($[69] !== dangerouslyAssumeSchemaIsValid || $[70] !== fetcher || $[71] !== schema) {
    t16 = [schema, dangerouslyAssumeSchemaIsValid, fetcher];
    $[69] = dangerouslyAssumeSchemaIsValid;
    $[70] = fetcher;
    $[71] = schema;
    $[72] = t16;
  } else {
    t16 = $[72];
  }
  useEffect(t15, t16);
  let t17;
  let t18;
  if ($[73] === Symbol.for("react.memo_cache_sentinel")) {
    t17 = () => {
      const runIntrospection = function runIntrospection2(event) {
        if (event.ctrlKey && event.key === "R") {
          const {
            actions: actions_2
          } = storeRef.current.getState();
          actions_2.introspect();
        }
      };
      window.addEventListener("keydown", runIntrospection);
      return () => {
        window.removeEventListener("keydown", runIntrospection);
      };
    };
    t18 = [];
    $[73] = t17;
    $[74] = t18;
  } else {
    t17 = $[73];
    t18 = $[74];
  }
  useEffect(t17, t18);
  let t19;
  if ($[75] === Symbol.for("react.memo_cache_sentinel")) {
    t19 = [];
    $[75] = t19;
  } else {
    t19 = $[75];
  }
  useEffect(_temp, t19);
  let t20;
  if ($[76] !== children) {
    t20 = /* @__PURE__ */ jsx(GraphiQLContext.Provider, { value: storeRef, children });
    $[76] = children;
    $[77] = t20;
  } else {
    t20 = $[77];
  }
  return t20;
};
function useGraphiQL(selector) {
  const store = useContext(GraphiQLContext);
  if (!store) {
    throw new Error("Missing `GraphiQLContext.Provider` in the tree.");
  }
  return useStore(store.current, useShallow(selector));
}
const useGraphiQLActions = () => {
  return useGraphiQL(_temp2);
};
function getExternalFragments(externalFragments) {
  const map = /* @__PURE__ */ new Map();
  if (externalFragments) {
    if (Array.isArray(externalFragments)) {
      for (const fragment of externalFragments) {
        map.set(fragment.name.value, fragment);
      }
    } else if (typeof externalFragments === "string") {
      visit(parse(externalFragments), {
        FragmentDefinition(fragment) {
          map.set(fragment.name.value, fragment);
        }
      });
    } else {
      throw new TypeError("The `externalFragments` prop must either be a string that contains the fragment definitions in SDL or a list of `FragmentDefinitionNode` objects.");
    }
  }
  return map;
}
function _temp() {
  languages.json.jsonDefaults.setDiagnosticsOptions(JSON_DIAGNOSTIC_OPTIONS);
}
function _temp2(state) {
  return state.actions;
}
export {
  GraphiQLProvider,
  useGraphiQL,
  useGraphiQLActions
};
//# sourceMappingURL=provider.js.map
