import { ComponentType, FC } from 'react';
import { EditorProps } from '../types';
import { editor as monacoEditor, Position } from '../monaco-editor';
declare type ResponseTooltipType = ComponentType<{
    /**
     * A position in the editor.
     */
    position: Position;
    /**
     * Word that has been hovered over.
     */
    word: monacoEditor.IWordAtPosition;
}>;
interface ResponseEditorProps extends EditorProps {
    /**
     * Customize the tooltip when hovering over properties in the response editor.
     */
    responseTooltip?: ResponseTooltipType;
}
export declare const ResponseEditor: FC<ResponseEditorProps>;
export {};
