import { jsx, jsxs, Fragment } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { formatError } from "@graphiql/toolkit";
import { useRef, useEffect } from "react";
import { createRoot } from "react-dom/client";
import { useGraphiQLActions, useGraphiQL } from "./provider.js";
import { ImagePreview } from "./image-preview.js";
import { URI_NAME, KEY_BINDINGS } from "../constants.js";
import { onEditorContainerKeyDown, getOrCreateModel, createEditor } from "../utility/create-editor.js";
import { pick } from "../utility/pick.js";
import { cleanupDisposables } from "../utility/cleanup-disposables.js";
import { clsx } from "clsx";
import { languages, Range } from "monaco-editor";
const ResponseEditor = (t0) => {
  const $ = c(20);
  let ResponseTooltip;
  let props;
  if ($[0] !== t0) {
    ({
      responseTooltip: ResponseTooltip,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = ResponseTooltip;
    $[2] = props;
  } else {
    ResponseTooltip = $[1];
    props = $[2];
  }
  const {
    setEditor,
    run
  } = useGraphiQLActions();
  let t1;
  if ($[3] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = pick("fetchError", "validationErrors", "responseEditor", "uriInstanceId");
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  const {
    fetchError,
    validationErrors,
    responseEditor,
    uriInstanceId
  } = useGraphiQL(t1);
  const ref = useRef(null);
  let t2;
  let t3;
  if ($[4] !== fetchError || $[5] !== responseEditor || $[6] !== validationErrors) {
    t2 = () => {
      if (fetchError) {
        responseEditor == null ? void 0 : responseEditor.setValue(fetchError);
      }
      if (validationErrors.length) {
        responseEditor == null ? void 0 : responseEditor.setValue(formatError(validationErrors));
      }
    };
    t3 = [responseEditor, fetchError, validationErrors];
    $[4] = fetchError;
    $[5] = responseEditor;
    $[6] = validationErrors;
    $[7] = t2;
    $[8] = t3;
  } else {
    t2 = $[7];
    t3 = $[8];
  }
  useEffect(t2, t3);
  let t4;
  if ($[9] !== ResponseTooltip || $[10] !== run || $[11] !== setEditor || $[12] !== uriInstanceId) {
    t4 = () => {
      const model = getOrCreateModel({
        uri: `${uriInstanceId}${URI_NAME.response}`,
        value: ""
      });
      const editor = createEditor(ref, {
        model,
        readOnly: true,
        lineNumbers: "off",
        wordWrap: "on",
        contextmenu: false
      });
      setEditor({
        responseEditor: editor
      });
      let lastRoot;
      let timerId;
      const provideHover = ($model, position) => {
        const sameModel = $model.uri === model.uri;
        if (!sameModel) {
          return null;
        }
        const wordAtPosition = $model.getWordAtPosition(position);
        if (!(wordAtPosition == null ? void 0 : wordAtPosition.word.startsWith("/"))) {
          return null;
        }
        const shouldRender = ImagePreview.shouldRender(wordAtPosition.word);
        if (!shouldRender) {
          return null;
        }
        const hoverId = `hover-${position.lineNumber}-${position.column}`;
        if (timerId) {
          clearTimeout(timerId);
        }
        timerId = setTimeout(() => {
          const el = document.querySelector(`[data-id="${hoverId}"]`);
          if (!el) {
            return;
          }
          lastRoot == null ? void 0 : lastRoot.unmount();
          lastRoot = createRoot(el);
          lastRoot.render(/* @__PURE__ */ jsxs(Fragment, { children: [
            ResponseTooltip && /* @__PURE__ */ jsx(ResponseTooltip, { position, word: wordAtPosition }),
            /* @__PURE__ */ jsx(ImagePreview, { path: wordAtPosition.word })
          ] }));
        }, 500);
        return {
          range: new Range(position.lineNumber, wordAtPosition.startColumn, position.lineNumber, wordAtPosition.endColumn),
          contents: [{
            value: `<div data-id="${hoverId}">Loading...</div>`,
            supportHtml: true
          }]
        };
      };
      const languageId = model.getLanguageId();
      const disposables = [languages.registerHoverProvider(languageId, {
        provideHover
      }), editor.addAction({
        ...KEY_BINDINGS.runQuery,
        run
      }), editor, model];
      return cleanupDisposables(disposables);
    };
    $[9] = ResponseTooltip;
    $[10] = run;
    $[11] = setEditor;
    $[12] = uriInstanceId;
    $[13] = t4;
  } else {
    t4 = $[13];
  }
  let t5;
  if ($[14] === Symbol.for("react.memo_cache_sentinel")) {
    t5 = [];
    $[14] = t5;
  } else {
    t5 = $[14];
  }
  useEffect(t4, t5);
  let t6;
  if ($[15] !== props.className) {
    t6 = clsx("result-window", props.className);
    $[15] = props.className;
    $[16] = t6;
  } else {
    t6 = $[16];
  }
  let t7;
  if ($[17] !== props || $[18] !== t6) {
    t7 = /* @__PURE__ */ jsx("section", { ref, "aria-label": "Result Window", "aria-live": "polite", "aria-atomic": "true", tabIndex: 0, onKeyDown: onEditorContainerKeyDown, ...props, className: t6 });
    $[17] = props;
    $[18] = t6;
    $[19] = t7;
  } else {
    t7 = $[19];
  }
  return t7;
};
export {
  ResponseEditor
};
//# sourceMappingURL=response-editor.js.map
