import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { forwardRef } from "react";
import { Reorder } from "framer-motion";
import { CloseIcon } from "../../icons/index.js";
import { UnStyledButton } from "../button/index.js";
/* empty css          */
import { clsx } from "clsx";
const TabRoot = forwardRef((t0, ref) => {
  const $ = c(16);
  let children;
  let className;
  let isActive;
  let props;
  let value;
  if ($[0] !== t0) {
    ({
      isActive,
      value,
      children,
      className,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = children;
    $[2] = className;
    $[3] = isActive;
    $[4] = props;
    $[5] = value;
  } else {
    children = $[1];
    className = $[2];
    isActive = $[3];
    props = $[4];
    value = $[5];
  }
  const t1 = isActive && "graphiql-tab-active";
  let t2;
  if ($[6] !== className || $[7] !== t1) {
    t2 = clsx("graphiql-tab", t1, className);
    $[6] = className;
    $[7] = t1;
    $[8] = t2;
  } else {
    t2 = $[8];
  }
  let t3;
  if ($[9] !== children || $[10] !== isActive || $[11] !== props || $[12] !== ref || $[13] !== t2 || $[14] !== value) {
    t3 = /* @__PURE__ */ jsx(Reorder.Item, { ...props, ref, value, "aria-selected": isActive, dragElastic: false, role: "tab", className: t2, children });
    $[9] = children;
    $[10] = isActive;
    $[11] = props;
    $[12] = ref;
    $[13] = t2;
    $[14] = value;
    $[15] = t3;
  } else {
    t3 = $[15];
  }
  return t3;
});
TabRoot.displayName = "Tab";
const TabButton = forwardRef((t0, ref) => {
  const $ = c(11);
  let children;
  let className;
  let props;
  if ($[0] !== t0) {
    ({
      children,
      className,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = children;
    $[2] = className;
    $[3] = props;
  } else {
    children = $[1];
    className = $[2];
    props = $[3];
  }
  let t1;
  if ($[4] !== className) {
    t1 = clsx("graphiql-tab-button", className);
    $[4] = className;
    $[5] = t1;
  } else {
    t1 = $[5];
  }
  let t2;
  if ($[6] !== children || $[7] !== props || $[8] !== ref || $[9] !== t1) {
    t2 = /* @__PURE__ */ jsx(UnStyledButton, { ...props, ref, type: "button", className: t1, children });
    $[6] = children;
    $[7] = props;
    $[8] = ref;
    $[9] = t1;
    $[10] = t2;
  } else {
    t2 = $[10];
  }
  return t2;
});
TabButton.displayName = "Tab.Button";
const TabClose = forwardRef((props, ref) => {
  const $ = c(7);
  let t0;
  if ($[0] !== props.className) {
    t0 = clsx("graphiql-tab-close", props.className);
    $[0] = props.className;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  let t1;
  if ($[2] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = /* @__PURE__ */ jsx(CloseIcon, {});
    $[2] = t1;
  } else {
    t1 = $[2];
  }
  let t2;
  if ($[3] !== props || $[4] !== ref || $[5] !== t0) {
    t2 = /* @__PURE__ */ jsx(UnStyledButton, { "aria-label": "Close Tab", ...props, ref, type: "button", className: t0, children: t1 });
    $[3] = props;
    $[4] = ref;
    $[5] = t0;
    $[6] = t2;
  } else {
    t2 = $[6];
  }
  return t2;
});
TabClose.displayName = "Tab.Close";
const Tab = Object.assign(TabRoot, {
  Button: TabButton,
  Close: TabClose
});
const Tabs = forwardRef((t0, ref) => {
  const $ = c(15);
  let children;
  let className;
  let onReorder;
  let props;
  let values;
  if ($[0] !== t0) {
    ({
      values,
      onReorder,
      children,
      className,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = children;
    $[2] = className;
    $[3] = onReorder;
    $[4] = props;
    $[5] = values;
  } else {
    children = $[1];
    className = $[2];
    onReorder = $[3];
    props = $[4];
    values = $[5];
  }
  let t1;
  if ($[6] !== className) {
    t1 = clsx("graphiql-tabs", className);
    $[6] = className;
    $[7] = t1;
  } else {
    t1 = $[7];
  }
  let t2;
  if ($[8] !== children || $[9] !== onReorder || $[10] !== props || $[11] !== ref || $[12] !== t1 || $[13] !== values) {
    t2 = /* @__PURE__ */ jsx(Reorder.Group, { ...props, ref, values, onReorder, axis: "x", role: "tablist", className: t1, children });
    $[8] = children;
    $[9] = onReorder;
    $[10] = props;
    $[11] = ref;
    $[12] = t1;
    $[13] = values;
    $[14] = t2;
  } else {
    t2 = $[14];
  }
  return t2;
});
Tabs.displayName = "Tabs";
export {
  Tab,
  Tabs
};
//# sourceMappingURL=index.js.map
