import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import { useRef, useEffect } from "react";
import { useGraphiQLActions, useGraphiQL } from "./provider.js";
import { STORAGE_KEY, URI_NAME, KEY_BINDINGS } from "../constants.js";
import { useChangeHandler } from "../utility/hooks.js";
import { onEditorContainerKeyDown, getOrCreateModel, createEditor } from "../utility/create-editor.js";
import { pick } from "../utility/pick.js";
import { cleanupDisposables } from "../utility/cleanup-disposables.js";
import { clsx } from "clsx";
const VariablesEditor = (t0) => {
  const $ = c(17);
  let onEdit;
  let props;
  if ($[0] !== t0) {
    ({
      onEdit,
      ...props
    } = t0);
    $[0] = t0;
    $[1] = onEdit;
    $[2] = props;
  } else {
    onEdit = $[1];
    props = $[2];
  }
  const {
    setEditor,
    run,
    prettifyEditors,
    mergeQuery
  } = useGraphiQLActions();
  let t1;
  if ($[3] === Symbol.for("react.memo_cache_sentinel")) {
    t1 = pick("initialVariables", "uriInstanceId");
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  const {
    initialVariables,
    uriInstanceId
  } = useGraphiQL(t1);
  const ref = useRef(null);
  useChangeHandler(onEdit, STORAGE_KEY.variables, "variables");
  let t2;
  if ($[4] !== initialVariables || $[5] !== mergeQuery || $[6] !== prettifyEditors || $[7] !== run || $[8] !== setEditor || $[9] !== uriInstanceId) {
    t2 = () => {
      const model = getOrCreateModel({
        uri: `${uriInstanceId}${URI_NAME.variables}`,
        value: initialVariables
      });
      const editor = createEditor(ref, {
        model
      });
      setEditor({
        variableEditor: editor
      });
      const disposables = [editor.addAction({
        ...KEY_BINDINGS.runQuery,
        run
      }), editor.addAction({
        ...KEY_BINDINGS.prettify,
        run: prettifyEditors
      }), editor.addAction({
        ...KEY_BINDINGS.mergeFragments,
        run: mergeQuery
      }), editor, model];
      return cleanupDisposables(disposables);
    };
    $[4] = initialVariables;
    $[5] = mergeQuery;
    $[6] = prettifyEditors;
    $[7] = run;
    $[8] = setEditor;
    $[9] = uriInstanceId;
    $[10] = t2;
  } else {
    t2 = $[10];
  }
  let t3;
  if ($[11] === Symbol.for("react.memo_cache_sentinel")) {
    t3 = [];
    $[11] = t3;
  } else {
    t3 = $[11];
  }
  useEffect(t2, t3);
  let t4;
  if ($[12] !== props.className) {
    t4 = clsx("graphiql-editor", props.className);
    $[12] = props.className;
    $[13] = t4;
  } else {
    t4 = $[13];
  }
  let t5;
  if ($[14] !== props || $[15] !== t4) {
    t5 = /* @__PURE__ */ jsx("div", { ref, tabIndex: 0, onKeyDown: onEditorContainerKeyDown, ...props, className: t4 });
    $[14] = props;
    $[15] = t4;
    $[16] = t5;
  } else {
    t5 = $[16];
  }
  return t5;
};
export {
  VariablesEditor
};
//# sourceMappingURL=variables-editor.js.map
