import { DiagnosticSettings } from 'monaco-graphql';
import { languages } from './monaco-editor';
import { EditorSlice } from './stores';
export declare const isMacOs: boolean;
export declare function formatShortcutForOS(key: string, replaced?: string): string;
export declare const KEY_MAP: Readonly<{
    prettify: {
        key: string;
        keybindings: number[];
    };
    mergeFragments: {
        key: string;
        keybindings: number[];
    };
    runQuery: {
        key: string;
        keybindings: number[];
    };
    autoComplete: {
        key: string;
    };
    copyQuery: {
        key: string;
        keybindings: number[];
    };
    refetchSchema: {
        key: string;
    };
    searchInEditor: {
        key: string;
    };
    searchInDocs: {
        key: string;
    };
}>;
export declare const STORAGE_KEY: {
    readonly headers: "headers";
    readonly visiblePlugin: "visiblePlugin";
    readonly query: "query";
    readonly variables: "variables";
    readonly tabs: "tabState";
    readonly persistHeaders: "shouldPersistHeaders";
    readonly theme: "theme";
};
export declare const DEFAULT_QUERY: string;
export declare const KEY_BINDINGS: {
    readonly prettify: {
        readonly id: "graphql-prettify";
        readonly label: "Prettify Editors";
        readonly contextMenuGroupId: "graphql";
        readonly keybindings: number[];
    };
    readonly mergeFragments: {
        readonly id: "graphql-merge";
        readonly label: "Merge Fragments into Query";
        readonly contextMenuGroupId: "graphql";
        readonly keybindings: number[];
    };
    readonly runQuery: {
        readonly id: "graphql-run";
        readonly label: "Run Operation";
        readonly contextMenuGroupId: "graphql";
        readonly keybindings: number[];
    };
    readonly copyQuery: {
        readonly id: "graphql-copy";
        readonly label: "Copy Query";
        readonly contextMenuGroupId: "graphql";
        readonly keybindings: number[];
    };
};
export declare const URI_NAME: {
    readonly operation: "operation.graphql";
    readonly schema: "schema.graphql";
    readonly variables: "variables.json";
    readonly requestHeaders: "request-headers.json";
    readonly response: "response.json";
};
export declare const JSON_DIAGNOSTIC_OPTIONS: languages.json.DiagnosticsOptions;
export declare const MONACO_GRAPHQL_DIAGNOSTIC_SETTINGS: DiagnosticSettings;
export declare const MONACO_GRAPHQL_API: import('monaco-graphql').MonacoGraphQLAPI;
export declare const DEFAULT_PRETTIFY_QUERY: EditorSlice['onPrettifyQuery'];
