import { c } from "react-compiler-runtime";
import { useStorage } from "./stores/storage.js";
import { useGraphiQLActions, useGraphiQL } from "./components/provider.js";
import { pick } from "./utility/pick.js";
function usePrettifyEditors() {
  const {
    prettifyEditors
  } = useGraphiQLActions();
  return prettifyEditors;
}
function useCopyQuery() {
  const {
    copyQuery
  } = useGraphiQLActions();
  return copyQuery;
}
function useMergeQuery() {
  const {
    mergeQuery
  } = useGraphiQLActions();
  return mergeQuery;
}
function useExecutionContext() {
  const $ = c(4);
  const {
    run,
    stop
  } = useGraphiQLActions();
  const values = useGraphiQL(_temp);
  let t0;
  if ($[0] !== run || $[1] !== stop || $[2] !== values) {
    t0 = {
      run,
      stop,
      ...values
    };
    $[0] = run;
    $[1] = stop;
    $[2] = values;
    $[3] = t0;
  } else {
    t0 = $[3];
  }
  return t0;
}
function _temp(state) {
  return {
    isFetching: state.isIntrospecting,
    isSubscribed: Boolean(state.subscription),
    operationName: state.operationName
  };
}
function usePluginContext() {
  const $ = c(4);
  const {
    setVisiblePlugin
  } = useGraphiQLActions();
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = pick("plugins", "visiblePlugin");
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const values = useGraphiQL(t0);
  let t1;
  if ($[1] !== setVisiblePlugin || $[2] !== values) {
    t1 = {
      setVisiblePlugin,
      ...values
    };
    $[1] = setVisiblePlugin;
    $[2] = values;
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  return t1;
}
function useSchemaContext() {
  const $ = c(4);
  const {
    introspect
  } = useGraphiQLActions();
  let t0;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = pick("fetchError", "isFetching", "schema", "validationErrors");
    $[0] = t0;
  } else {
    t0 = $[0];
  }
  const values = useGraphiQL(t0);
  let t1;
  if ($[1] !== introspect || $[2] !== values) {
    t1 = {
      introspect,
      ...values
    };
    $[1] = introspect;
    $[2] = values;
    $[3] = t1;
  } else {
    t1 = $[3];
  }
  return t1;
}
const useStorageContext = useStorage;
export {
  useCopyQuery,
  useExecutionContext,
  useMergeQuery,
  usePluginContext,
  usePrettifyEditors,
  useSchemaContext,
  useStorageContext
};
//# sourceMappingURL=deprecated.js.map
