import { jsx } from "react/jsx-runtime";
import { c } from "react-compiler-runtime";
import SvgArgument from "./argument.js";
import SvgChevronDown from "./chevron-down.js";
import SvgChevronLeft from "./chevron-left.js";
import SvgChevronUp from "./chevron-up.js";
import SvgClose from "./close.js";
import SvgCopy from "./copy.js";
import SvgDeprecatedArgument from "./deprecated-argument.js";
import SvgDeprecatedEnumValue from "./deprecated-enum-value.js";
import SvgDeprecatedField from "./deprecated-field.js";
import SvgDirective from "./directive.js";
import SvgDocsFilled from "./docs-filled.js";
import SvgDocs from "./docs.js";
import SvgEnumValue from "./enum-value.js";
import SvgField from "./field.js";
import SvgHistory from "./history.js";
import SvgImplements from "./implements.js";
import SvgKeyboardShortcut from "./keyboard-shortcut.js";
import SvgMagnifyingGlass from "./magnifying-glass.js";
import SvgMerge from "./merge.js";
import SvgPen from "./pen.js";
import SvgPlay from "./play.js";
import SvgPlus from "./plus.js";
import SvgPrettify from "./prettify.js";
import SvgReload from "./reload.js";
import SvgRootType from "./root-type.js";
import SvgSettings from "./settings.js";
import SvgStarFilled from "./star-filled.js";
import SvgStar from "./star.js";
import SvgStop from "./stop.js";
import SvgTrash from "./trash.js";
import SvgType from "./type.js";
const ArgumentIcon = generateIcon(SvgArgument);
const ChevronDownIcon = generateIcon(SvgChevronDown);
const ChevronLeftIcon = generateIcon(SvgChevronLeft);
const ChevronUpIcon = generateIcon(SvgChevronUp);
const CloseIcon = generateIcon(SvgClose);
const CopyIcon = generateIcon(SvgCopy);
const DeprecatedArgumentIcon = generateIcon(SvgDeprecatedArgument);
const DeprecatedEnumValueIcon = generateIcon(SvgDeprecatedEnumValue);
const DeprecatedFieldIcon = generateIcon(SvgDeprecatedField);
const DirectiveIcon = generateIcon(SvgDirective);
const DocsFilledIcon = generateIcon(SvgDocsFilled);
const DocsIcon = generateIcon(SvgDocs);
const EnumValueIcon = generateIcon(SvgEnumValue);
const FieldIcon = generateIcon(SvgField);
const HistoryIcon = generateIcon(SvgHistory);
const ImplementsIcon = generateIcon(SvgImplements);
const KeyboardShortcutIcon = generateIcon(SvgKeyboardShortcut);
const MagnifyingGlassIcon = generateIcon(SvgMagnifyingGlass);
const MergeIcon = generateIcon(SvgMerge);
const PenIcon = generateIcon(SvgPen);
const PlayIcon = generateIcon(SvgPlay);
const PlusIcon = generateIcon(SvgPlus);
const PrettifyIcon = generateIcon(SvgPrettify);
const ReloadIcon = generateIcon(SvgReload);
const RootTypeIcon = generateIcon(SvgRootType);
const SettingsIcon = generateIcon(SvgSettings);
const StarFilledIcon = generateIcon(SvgStarFilled);
const StarIcon = generateIcon(SvgStar);
const StopIcon = generateIcon(SvgStop);
const TrashIcon = generateIcon(SvgTrash);
const TypeIcon = generateIcon(SvgType);
function generateIcon(RawComponent) {
  const title = RawComponent.name.replace("Svg", "").replaceAll(/([A-Z])/g, " $1").trimStart().toLowerCase() + " icon";
  const IconComponent = (props) => {
    const $ = c(2);
    let t0;
    if ($[0] !== props) {
      t0 = /* @__PURE__ */ jsx(RawComponent, { title, ...props });
      $[0] = props;
      $[1] = t0;
    } else {
      t0 = $[1];
    }
    return t0;
  };
  IconComponent.displayName = RawComponent.name;
  return IconComponent;
}
export {
  ArgumentIcon,
  ChevronDownIcon,
  ChevronLeftIcon,
  ChevronUpIcon,
  CloseIcon,
  CopyIcon,
  DeprecatedArgumentIcon,
  DeprecatedEnumValueIcon,
  DeprecatedFieldIcon,
  DirectiveIcon,
  DocsFilledIcon,
  DocsIcon,
  EnumValueIcon,
  FieldIcon,
  HistoryIcon,
  ImplementsIcon,
  KeyboardShortcutIcon,
  MagnifyingGlassIcon,
  MergeIcon,
  PenIcon,
  PlayIcon,
  PlusIcon,
  PrettifyIcon,
  ReloadIcon,
  RootTypeIcon,
  SettingsIcon,
  StarFilledIcon,
  StarIcon,
  StopIcon,
  TrashIcon,
  TypeIcon
};
//# sourceMappingURL=index.js.map
