import * as monacoEditor from "monaco-editor";
export * from "monaco-editor";
import { MouseTargetFactory } from "monaco-editor/esm/vs/editor/browser/controller/mouseTarget.js";
if (navigator.userAgent.includes("Firefox/")) {
  const originalFn = MouseTargetFactory._doHitTestWithCaretPositionFromPoint;
  MouseTargetFactory._doHitTestWithCaretPositionFromPoint = (...args) => {
    const [ctx, coords] = args;
    const hitResult = ctx.viewDomNode.ownerDocument.caretPositionFromPoint(coords.clientX, coords.clientY);
    if (hitResult) {
      const result = originalFn(...args);
      return result;
    }
    return {
      type: 0
    };
  };
}
//# sourceMappingURL=monaco-editor.js.map
