import { Fetcher, GetDefaultFieldNamesFn, Unsubscribable } from '@graphiql/toolkit';
import { StateCreator } from 'zustand';
import { SlicesWithActions } from '../types';
export interface ExecutionSlice {
    /**
     * If there is currently a GraphQL request in-flight. For multipart
     * requests like subscriptions, this will be `true` while fetching the
     * first partial response and `false` while fetching subsequent batches.
     * @default false
     */
    isFetching: boolean;
    /**
     * Represents an active GraphQL subscription.
     *
     * For multipart operations such as subscriptions, this
     * will hold an `Unsubscribable` object while the request is in-flight. It
     * remains non-null until the operation completes or is manually unsubscribed.
     *
     * @remarks Use `subscription?.unsubscribe()` to cancel the request.
     * @default null
     */
    subscription: Unsubscribable | null;
    /**
     * The operation name that will be sent with all GraphQL requests.
     * @default null
     */
    overrideOperationName: string | null;
    /**
     * A function to determine which field leafs are automatically added when
     * trying to execute a query with missing selection sets. It will be called
     * with the `GraphQLType` for which fields need to be added.
     */
    getDefaultFieldNames?: GetDefaultFieldNamesFn;
    /**
     * @default 0
     */
    queryId: number;
    /**
     * A function which accepts GraphQL HTTP parameters and returns a `Promise`,
     * `Observable` or `AsyncIterable` that returns the GraphQL response in
     * parsed JSON format.
     *
     * We suggest using the `createGraphiQLFetcher` utility from `@graphiql/toolkit`
     * to create these fetcher functions.
     *
     * @see {@link https://graphiql-test.netlify.app/typedoc/modules/graphiql_toolkit.html#creategraphiqlfetcher-2|`createGraphiQLFetcher`}
     */
    fetcher: Fetcher;
}
export interface ExecutionActions {
    /**
     * Start a GraphQL request based on the current editor contents.
     */
    run(): void;
    /**
     * Stop the GraphQL request that is currently in-flight.
     */
    stop(): void;
}
export interface ExecutionProps extends Pick<ExecutionSlice, 'getDefaultFieldNames' | 'fetcher'> {
    /**
     * This prop sets the operation name that is passed with a GraphQL request.
     */
    operationName?: string;
}
declare type CreateExecutionSlice = (initial: Pick<ExecutionSlice, 'overrideOperationName' | 'getDefaultFieldNames' | 'fetcher'>) => StateCreator<SlicesWithActions, [
], [
], ExecutionSlice & {
    actions: ExecutionActions;
}>;
export declare const createExecutionSlice: CreateExecutionSlice;
export {};
