import { storageStore } from "./storage.js";
import { STORAGE_KEY } from "../constants.js";
const createPluginSlice = (initial) => (set) => ({
  plugins: [],
  visiblePlugin: null,
  ...initial,
  actions: {
    setVisiblePlugin(plugin = null) {
      set((current) => {
        const {
          visiblePlugin: currentVisiblePlugin,
          plugins,
          onTogglePluginVisibility
        } = current;
        const byTitle = typeof plugin === "string";
        const newVisiblePlugin = plugin && plugins.find((p) => (byTitle ? p.title : p) === plugin) || null;
        if (newVisiblePlugin === currentVisiblePlugin) {
          return current;
        }
        onTogglePluginVisibility == null ? void 0 : onTogglePluginVisibility(newVisiblePlugin);
        const {
          storage
        } = storageStore.getState();
        storage.set(STORAGE_KEY.visiblePlugin, (newVisiblePlugin == null ? void 0 : newVisiblePlugin.title) ?? "");
        return {
          visiblePlugin: newVisiblePlugin
        };
      });
    },
    setPlugins(plugins) {
      const seenTitles = /* @__PURE__ */ new Set();
      const msg = "All GraphiQL plugins must have a unique title";
      for (const {
        title
      } of plugins) {
        if (typeof title !== "string" || !title) {
          throw new Error(msg);
        }
        if (seenTitles.has(title)) {
          throw new Error(`${msg}, found two plugins with the title '${title}'`);
        }
        seenTitles.add(title);
      }
      set({
        plugins
      });
    }
  }
});
export {
  createPluginSlice
};
//# sourceMappingURL=plugin.js.map
