import { FC, ReactNode } from 'react';
import { EDITOR_THEME } from '../utility/create-editor';
import { editor as monacoEditor } from '../monaco-editor';
/**
 * The value `null` semantically means that the user does not explicitly choose
 * any theme, so we use the system default.
 */
export declare type Theme = 'light' | 'dark' | null;
declare type MonacoTheme = monacoEditor.BuiltinTheme | (typeof EDITOR_THEME)[keyof typeof EDITOR_THEME] | ({} & string);
interface ThemeStoreType {
    theme: Theme;
    /**
     * Set a new theme
     */
    setTheme: (newTheme: Theme) => void;
}
interface ThemeStoreProps {
    children: ReactNode;
    /**
     * @default null
     */
    defaultTheme?: Theme;
    /**
     * Sets the color theme for the monaco editors.
     * @default { dark: 'graphiql-DARK', light: 'graphiql-LIGHT' }
     */
    editorTheme?: {
        dark: MonacoTheme;
        light: MonacoTheme;
    };
}
export declare const themeStore: import('zustand').StoreApi<ThemeStoreType>;
export declare const ThemeStore: FC<ThemeStoreProps>;
export declare const useTheme: {
    (): ThemeStoreType;
    <T>(selector: (state: ThemeStoreType) => T): T;
};
export {};
