import { c } from "react-compiler-runtime";
import { useEffect } from "react";
import { storageStore } from "./storage.js";
import { createStore } from "zustand";
import { EDITOR_THEME } from "../utility/create-editor.js";
import { STORAGE_KEY } from "../constants.js";
import { createBoundedUseStore } from "../utility/create-bounded-use-store.js";
import { editor } from "monaco-editor";
const themeStore = createStore((set) => ({
  theme: null,
  setTheme(theme) {
    const {
      storage
    } = storageStore.getState();
    storage.set(STORAGE_KEY.theme, theme ?? "");
    set({
      theme
    });
  }
}));
const ThemeStore = (t0) => {
  const $ = c(7);
  const {
    children,
    defaultTheme: t1,
    editorTheme: t2
  } = t0;
  const defaultTheme = t1 === void 0 ? null : t1;
  const editorTheme = t2 === void 0 ? EDITOR_THEME : t2;
  const theme = useTheme(_temp);
  let t3;
  if ($[0] !== defaultTheme) {
    t3 = () => {
      const {
        storage
      } = storageStore.getState();
      const getInitialTheme = function getInitialTheme2() {
        const stored = storage.get(STORAGE_KEY.theme);
        switch (stored) {
          case "light": {
            return "light";
          }
          case "dark": {
            return "dark";
          }
          default: {
            if (typeof stored === "string") {
              storage.set(STORAGE_KEY.theme, "");
            }
            return defaultTheme;
          }
        }
      };
      themeStore.setState({
        theme: getInitialTheme()
      });
    };
    $[0] = defaultTheme;
    $[1] = t3;
  } else {
    t3 = $[1];
  }
  let t4;
  if ($[2] === Symbol.for("react.memo_cache_sentinel")) {
    t4 = [];
    $[2] = t4;
  } else {
    t4 = $[2];
  }
  useEffect(t3, t4);
  let t5;
  let t6;
  if ($[3] !== editorTheme || $[4] !== theme) {
    t5 = () => {
      document.body.classList.remove("graphiql-light", "graphiql-dark");
      if (theme) {
        document.body.classList.add(`graphiql-${theme}`);
      }
      const resolvedTheme = theme ?? getSystemTheme();
      editor.setTheme(editorTheme[resolvedTheme]);
    };
    t6 = [theme, editorTheme];
    $[3] = editorTheme;
    $[4] = theme;
    $[5] = t5;
    $[6] = t6;
  } else {
    t5 = $[5];
    t6 = $[6];
  }
  useEffect(t5, t6);
  return children;
};
function getSystemTheme() {
  const mediaQueryList = window.matchMedia("(prefers-color-scheme: dark)");
  const isDark = mediaQueryList.matches;
  const systemTheme = isDark ? "dark" : "light";
  return systemTheme;
}
const useTheme = createBoundedUseStore(themeStore);
function _temp(state) {
  return state.theme;
}
export {
  ThemeStore,
  themeStore,
  useTheme
};
//# sourceMappingURL=theme.js.map
