import { ComponentPropsWithoutRef } from 'react';
import { AllTypeInfo } from 'graphql-language-service/esm/types';
import { editor as monacoEditor } from './monaco-editor';
import { EditorSlice, ExecutionSlice, PluginSlice, SchemaSlice, EditorActions, ExecutionActions, PluginActions, SchemaActions } from './stores';
import { RuleKind } from 'graphql-language-service';
export declare type EditorProps = ComponentPropsWithoutRef<'div'>;
export interface SchemaReference {
    kind: RuleKind;
    typeInfo: AllTypeInfo;
}
export declare type MonacoEditor = monacoEditor.IStandaloneCodeEditor;
export declare type AllSlices = EditorSlice & ExecutionSlice & PluginSlice & SchemaSlice;
export declare type AllActions = EditorActions & ExecutionActions & PluginActions & SchemaActions;
export interface SlicesWithActions extends AllSlices {
    actions: AllActions;
}
