function debounce(duration, fn) {
  let timeout;
  return function(...args) {
    if (timeout) {
      clearTimeout(timeout);
    }
    timeout = setTimeout(() => {
      timeout = null;
      fn(...args);
    }, duration);
  };
}
export {
  debounce
};
//# sourceMappingURL=debounce.js.map
