import { useEffect } from 'react';
export declare function useChangeHandler(callback: ((value: string) => void) | undefined, storageKey: string | null, tabProperty: 'variables' | 'headers'): void;
export declare const useEditorState: (editor: 'query' | 'variable' | 'header') => [string, (val: string) => void];
/**
 * useState-like hook for the current tab operations editor state
 */
export declare const useOperationsEditorState: () => [operations: string, setOperations: (content: string) => void];
/**
 * useState-like hook for current tab variables editor state
 */
export declare const useVariablesEditorState: () => [variables: string, setVariables: (content: string) => void];
/**
 * useState-like hook for current tab variables editor state
 */
export declare const useHeadersEditorState: () => [headers: string, setHeaders: (content: string) => void];
/**
 * Implements an optimistic caching strategy around a useState-like hook in
 * order to prevent loss of updates when the hook has an internal delay and the
 * update function is called again before the updated state is sent out.
 *
 * Use this as a wrapper around `useOperationsEditorState`,
 * `useVariablesEditorState`, or `useHeadersEditorState` if you anticipate
 * calling them with great frequency (due to, for instance, mouse, keyboard, or
 * network events).
 *
 * @example
 * ```ts
 * const [operationsString, handleEditOperations] =
 *   useOptimisticState(useOperationsEditorState());
 * ```
 */
export declare function useOptimisticState([upstreamState, upstreamSetState,]: ReturnType<typeof useEditorState>): ReturnType<typeof useEditorState>;
export declare const useDidUpdate: typeof useEffect;
