import { c } from "react-compiler-runtime";
import { useRef, useState, useEffect, useCallback, useMemo } from "react";
import { debounce } from "./debounce.js";
import { useGraphiQL, useGraphiQLActions } from "../components/provider.js";
import { storageStore } from "../stores/storage.js";
function useChangeHandler(callback, storageKey, tabProperty) {
  const $ = c(9);
  const {
    updateActiveTabValues
  } = useGraphiQLActions();
  let t0;
  if ($[0] !== tabProperty) {
    t0 = (state) => state[tabProperty === "variables" ? "variableEditor" : "headerEditor"];
    $[0] = tabProperty;
    $[1] = t0;
  } else {
    t0 = $[1];
  }
  const editor = useGraphiQL(t0);
  let t1;
  let t2;
  if ($[2] !== callback || $[3] !== editor || $[4] !== storageKey || $[5] !== tabProperty || $[6] !== updateActiveTabValues) {
    t1 = () => {
      if (!editor) {
        return;
      }
      const {
        storage
      } = storageStore.getState();
      const store = debounce(500, (value) => {
        if (storageKey === null) {
          return;
        }
        storage.set(storageKey, value);
      });
      const updateTab = debounce(100, (value_0) => {
        updateActiveTabValues({
          [tabProperty]: value_0
        });
      });
      const handleChange = (_event) => {
        const newValue = editor.getValue();
        store(newValue);
        updateTab(newValue);
        callback == null ? void 0 : callback(newValue);
      };
      const disposable = editor.getModel().onDidChangeContent(handleChange);
      return () => {
        disposable.dispose();
      };
    };
    t2 = [callback, editor, storageKey, tabProperty, updateActiveTabValues];
    $[2] = callback;
    $[3] = editor;
    $[4] = storageKey;
    $[5] = tabProperty;
    $[6] = updateActiveTabValues;
    $[7] = t1;
    $[8] = t2;
  } else {
    t1 = $[7];
    t2 = $[8];
  }
  useEffect(t1, t2);
}
const useEditorState = (editor) => {
  "use no memo";
  const editorInstance = useGraphiQL((state) => state[`${editor}Editor`]);
  const editorValue = (editorInstance == null ? void 0 : editorInstance.getValue()) ?? "";
  const handleChange = useCallback((value) => editorInstance == null ? void 0 : editorInstance.setValue(value), [editorInstance]);
  return useMemo(() => [editorValue, handleChange], [editorValue, handleChange]);
};
const useOperationsEditorState = () => {
  return useEditorState("query");
};
const useVariablesEditorState = () => {
  return useEditorState("variable");
};
const useHeadersEditorState = () => {
  return useEditorState("header");
};
function useOptimisticState(t0) {
  const $ = c(12);
  const [upstreamState, upstreamSetState] = t0;
  let t1;
  if ($[0] !== upstreamState) {
    t1 = {
      pending: null,
      last: upstreamState
    };
    $[0] = upstreamState;
    $[1] = t1;
  } else {
    t1 = $[1];
  }
  const lastStateRef = useRef(t1);
  const [state, setOperationsText] = useState(upstreamState);
  let t2;
  let t3;
  if ($[2] !== state || $[3] !== upstreamSetState || $[4] !== upstreamState) {
    t2 = () => {
      if (lastStateRef.current.last === upstreamState) {
        return;
      }
      lastStateRef.current.last = upstreamState;
      if (lastStateRef.current.pending === null) {
        setOperationsText(upstreamState);
        return;
      }
      if (lastStateRef.current.pending === upstreamState) {
        lastStateRef.current.pending = null;
        if (upstreamState !== state) {
          lastStateRef.current.pending = state;
          upstreamSetState(state);
        }
        return;
      }
      lastStateRef.current.pending = null;
      setOperationsText(upstreamState);
    };
    t3 = [upstreamState, state, upstreamSetState];
    $[2] = state;
    $[3] = upstreamSetState;
    $[4] = upstreamState;
    $[5] = t2;
    $[6] = t3;
  } else {
    t2 = $[5];
    t3 = $[6];
  }
  useEffect(t2, t3);
  let t4;
  if ($[7] !== upstreamSetState) {
    t4 = (newState) => {
      setOperationsText(newState);
      if (lastStateRef.current.pending === null && lastStateRef.current.last !== newState) {
        lastStateRef.current.pending = newState;
        upstreamSetState(newState);
      }
    };
    $[7] = upstreamSetState;
    $[8] = t4;
  } else {
    t4 = $[8];
  }
  const setState = t4;
  let t5;
  if ($[9] !== setState || $[10] !== state) {
    t5 = [state, setState];
    $[9] = setState;
    $[10] = state;
    $[11] = t5;
  } else {
    t5 = $[11];
  }
  return t5;
}
const useDidUpdate = (fn, dependencies) => {
  const $ = c(4);
  const didMountRef = useRef(false);
  let t0;
  let t1;
  if ($[0] === Symbol.for("react.memo_cache_sentinel")) {
    t0 = () => () => {
      didMountRef.current = false;
    };
    t1 = [];
    $[0] = t0;
    $[1] = t1;
  } else {
    t0 = $[0];
    t1 = $[1];
  }
  useEffect(t0, t1);
  let t2;
  if ($[2] !== fn) {
    t2 = () => {
      if (didMountRef.current) {
        return fn();
      }
      didMountRef.current = true;
    };
    $[2] = fn;
    $[3] = t2;
  } else {
    t2 = $[3];
  }
  useEffect(t2, dependencies);
};
export {
  useChangeHandler,
  useDidUpdate,
  useEditorState,
  useHeadersEditorState,
  useOperationsEditorState,
  useOptimisticState,
  useVariablesEditorState
};
//# sourceMappingURL=hooks.js.map
