import prettier from "prettier/standalone";
import { printers } from "prettier/plugins/estree";
import { parsers } from "prettier/parser-babel";
import { parse, printParseErrorCode } from "jsonc-parser";
function formatJSONC(content) {
  return prettier.format(content, {
    parser: "jsonc",
    plugins: [
      // Fix: Couldn't find plugin for AST format "estree"
      {
        printers
      },
      // @ts-expect-error -- Fix Couldn't resolve parser "jsonc"
      {
        parsers
      }
    ],
    // always split into new lines, e.g. {"foo":true} => {\n  "foo": true\n}
    printWidth: 0
  });
}
const formatter = new Intl.ListFormat("en", {
  style: "long",
  type: "conjunction"
  // uses "and"
});
function parseJSONC(content) {
  const errors = [];
  const parsed = parse(content, errors, {
    allowTrailingComma: true,
    allowEmptyContent: true
  });
  if (errors.length) {
    const output = formatter.format(errors.map(({
      error
    }) => printParseErrorCode(error)));
    throw new SyntaxError(output);
  }
  return parsed;
}
function tryParseJSONC(json = "") {
  let parsed;
  try {
    parsed = parseJSONC(json);
  } catch (error) {
    throw new Error(`are invalid JSON: ${error instanceof Error ? error.message : error}.`);
  }
  if (!parsed) {
    return;
  }
  const isObject = typeof parsed === "object" && !Array.isArray(parsed);
  if (!isObject) {
    throw new TypeError("are not a JSON object.");
  }
  return parsed;
}
export {
  formatJSONC,
  parseJSONC,
  tryParseJSONC
};
//# sourceMappingURL=jsonc.js.map
