import { c } from "react-compiler-runtime";
import { useState, useRef, useEffect } from "react";
import { debounce } from "./debounce.js";
import { useStorage } from "../stores/storage.js";
function useDragResize(t0) {
  const $ = c(26);
  const {
    defaultSizeRelation: t1,
    direction,
    initiallyHidden,
    onHiddenElementChange,
    sizeThresholdFirst: t2,
    sizeThresholdSecond: t3,
    storageKey
  } = t0;
  const defaultSizeRelation = t1 === void 0 ? 1 : t1;
  const sizeThresholdFirst = t2 === void 0 ? 100 : t2;
  const sizeThresholdSecond = t3 === void 0 ? 100 : t3;
  const storage = useStorage();
  let t4;
  if ($[0] !== initiallyHidden || $[1] !== storage || $[2] !== storageKey) {
    t4 = () => {
      const storedValue = storageKey && storage.get(storageKey);
      if (storedValue === HIDE_FIRST || initiallyHidden === "first") {
        return "first";
      }
      if (storedValue === HIDE_SECOND || initiallyHidden === "second") {
        return "second";
      }
      return null;
    };
    $[0] = initiallyHidden;
    $[1] = storage;
    $[2] = storageKey;
    $[3] = t4;
  } else {
    t4 = $[3];
  }
  const [hiddenElement, setHiddenElement] = useState(t4);
  const firstRef = useRef(null);
  const dragBarRef = useRef(null);
  const secondRef = useRef(null);
  const defaultFlexRef = useRef(`${defaultSizeRelation}`);
  let t5;
  if ($[4] !== storage || $[5] !== storageKey) {
    t5 = () => {
      const storedValue_0 = storageKey && storage.get(storageKey) || defaultFlexRef.current;
      if (firstRef.current) {
        firstRef.current.style.flex = storedValue_0 === HIDE_FIRST || storedValue_0 === HIDE_SECOND ? defaultFlexRef.current : storedValue_0;
      }
      if (secondRef.current) {
        secondRef.current.style.flex = "1";
      }
    };
    $[4] = storage;
    $[5] = storageKey;
    $[6] = t5;
  } else {
    t5 = $[6];
  }
  let t6;
  if ($[7] !== direction || $[8] !== storage || $[9] !== storageKey) {
    t6 = [direction, storage, storageKey];
    $[7] = direction;
    $[8] = storage;
    $[9] = storageKey;
    $[10] = t6;
  } else {
    t6 = $[10];
  }
  useEffect(t5, t6);
  let t7;
  let t8;
  if ($[11] !== hiddenElement || $[12] !== storage || $[13] !== storageKey) {
    t7 = () => {
      const hide = function hide2(element) {
        element.style.left = "-1000px";
        element.style.position = "absolute";
        element.style.opacity = "0";
        if (!firstRef.current) {
          return;
        }
        const flex = parseFloat(firstRef.current.style.flex);
        if (!Number.isFinite(flex) || flex < 1) {
          firstRef.current.style.flex = "1";
        }
      };
      const show = function show2(element_0) {
        element_0.style.left = "";
        element_0.style.position = "";
        element_0.style.opacity = "";
        if (!storageKey) {
          return;
        }
        const storedValue_1 = storage.get(storageKey);
        if (firstRef.current && storedValue_1 !== HIDE_FIRST && storedValue_1 !== HIDE_SECOND) {
          firstRef.current.style.flex = storedValue_1 || defaultFlexRef.current;
        }
      };
      for (const id of ["first", "second"]) {
        const element_1 = (id === "first" ? firstRef : secondRef).current;
        if (element_1) {
          if (id === hiddenElement) {
            hide(element_1);
          } else {
            show(element_1);
          }
        }
      }
    };
    t8 = [hiddenElement, storage, storageKey];
    $[11] = hiddenElement;
    $[12] = storage;
    $[13] = storageKey;
    $[14] = t7;
    $[15] = t8;
  } else {
    t7 = $[14];
    t8 = $[15];
  }
  useEffect(t7, t8);
  let t10;
  let t9;
  if ($[16] !== direction || $[17] !== onHiddenElementChange || $[18] !== sizeThresholdFirst || $[19] !== sizeThresholdSecond || $[20] !== storage || $[21] !== storageKey) {
    t9 = () => {
      if (!dragBarRef.current || !firstRef.current || !secondRef.current) {
        return;
      }
      const store = debounce(500, (value) => {
        if (storageKey) {
          storage.set(storageKey, value);
        }
      });
      const setHiddenElementWithCallback = function setHiddenElementWithCallback2(element_2) {
        setHiddenElement((prevHiddenElement) => {
          if (element_2 === prevHiddenElement) {
            return prevHiddenElement;
          }
          onHiddenElementChange == null ? void 0 : onHiddenElementChange(element_2);
          return element_2;
        });
      };
      const dragBarContainer = dragBarRef.current;
      const firstContainer = firstRef.current;
      const wrapper = firstContainer.parentElement;
      const isHorizontal = direction === "horizontal";
      const eventProperty = isHorizontal ? "clientX" : "clientY";
      const rectProperty = isHorizontal ? "left" : "top";
      const adjacentRectProperty = isHorizontal ? "right" : "bottom";
      const sizeProperty = isHorizontal ? "clientWidth" : "clientHeight";
      const handleMouseDown = function handleMouseDown2(downEvent) {
        const isClickOnCurrentElement = downEvent.target === downEvent.currentTarget;
        if (!isClickOnCurrentElement) {
          return;
        }
        downEvent.preventDefault();
        const offset = downEvent[eventProperty] - dragBarContainer.getBoundingClientRect()[rectProperty];
        const handleMouseMove = function handleMouseMove2(moveEvent) {
          if (moveEvent.buttons === 0) {
            return handleMouseUp();
          }
          const domRect = wrapper.getBoundingClientRect();
          const firstSize = moveEvent[eventProperty] - domRect[rectProperty] - offset;
          const secondSize = domRect[adjacentRectProperty] - moveEvent[eventProperty] + offset - dragBarContainer[sizeProperty];
          if (firstSize < sizeThresholdFirst) {
            setHiddenElementWithCallback("first");
            store(HIDE_FIRST);
          } else {
            if (secondSize < sizeThresholdSecond) {
              setHiddenElementWithCallback("second");
              store(HIDE_SECOND);
            } else {
              setHiddenElementWithCallback(null);
              const newFlex = `${firstSize / secondSize}`;
              firstContainer.style.flex = newFlex;
              store(newFlex);
            }
          }
        };
        function handleMouseUp() {
          document.removeEventListener("mousemove", handleMouseMove);
          document.removeEventListener("mouseup", handleMouseUp);
        }
        document.addEventListener("mousemove", handleMouseMove);
        document.addEventListener("mouseup", handleMouseUp);
      };
      dragBarContainer.addEventListener("mousedown", handleMouseDown);
      const reset = function reset2() {
        if (firstRef.current) {
          firstRef.current.style.flex = defaultFlexRef.current;
        }
        store(defaultFlexRef.current);
        setHiddenElementWithCallback(null);
      };
      dragBarContainer.addEventListener("dblclick", reset);
      return () => {
        dragBarContainer.removeEventListener("mousedown", handleMouseDown);
        dragBarContainer.removeEventListener("dblclick", reset);
      };
    };
    t10 = [direction, onHiddenElementChange, sizeThresholdFirst, sizeThresholdSecond, storage, storageKey];
    $[16] = direction;
    $[17] = onHiddenElementChange;
    $[18] = sizeThresholdFirst;
    $[19] = sizeThresholdSecond;
    $[20] = storage;
    $[21] = storageKey;
    $[22] = t10;
    $[23] = t9;
  } else {
    t10 = $[22];
    t9 = $[23];
  }
  useEffect(t9, t10);
  let t11;
  if ($[24] !== hiddenElement) {
    t11 = {
      dragBarRef,
      hiddenElement,
      firstRef,
      setHiddenElement,
      secondRef
    };
    $[24] = hiddenElement;
    $[25] = t11;
  } else {
    t11 = $[25];
  }
  return t11;
}
const HIDE_FIRST = "hide-first";
const HIDE_SECOND = "hide-second";
export {
  useDragResize
};
//# sourceMappingURL=resize.js.map
