export interface TabDefinition {
    /**
     * The contents of the operation editor of this tab.
     */
    query: string | null;
    /**
     * The contents of the variables editor of this tab.
     */
    variables?: string | null;
    /**
     * The contents of the request headers editor of this tab.
     */
    headers?: string | null;
}
/**
 * This object describes the state of a single tab.
 */
export interface TabState extends TabDefinition {
    /**
     * A GUID value generated when the tab was created.
     */
    id: string;
    /**
     * A hash that is unique for a combination of the contents of the query
     * editor, the variables editor and the request headers editor (i.e., all the editor
     * where the contents are persisted in storage).
     */
    hash: string;
    /**
     * The title of the tab shown in the tab element.
     */
    title: string;
    /**
     * The operation name derived from the contents of the operation editor of this
     * tab.
     */
    operationName: string | null;
    /**
     * The contents of the response editor of this tab.
     */
    response: string | null;
}
/**
 * This object describes the state of all tabs.
 */
export declare type TabsState = {
    /**
     * A list of state objects for each tab.
     */
    tabs: TabState[];
    /**
     * The index of the currently active tab with regards to the `tabs` list of
     * this object.
     */
    activeTabIndex: number;
};
export declare function getDefaultTabState({ defaultQuery, defaultHeaders, headers, query, variables, defaultTabs, shouldPersistHeaders, }: {
    defaultQuery: string;
    defaultHeaders?: string;
    headers: string | null;
    defaultTabs?: TabDefinition[];
    query: string | null;
    variables: string | null;
    shouldPersistHeaders?: boolean;
}): TabsState;
export declare function serializeTabState(tabState: TabsState, shouldPersistHeaders?: boolean): string;
export declare function createTab({ query, variables, headers, }?: Partial<TabDefinition>): TabState;
export declare function setPropertiesInActiveTab(state: TabsState, partialTab: Partial<Omit<TabState, 'id' | 'hash' | 'title'>>): TabsState;
export declare function fuzzyExtractOperationName(str: string): string | null;
export declare function clearHeadersFromTabs(): void;
