import { StorageAPI } from '@graphiql/toolkit';
import { CodeMirrorEditorWithOperationFacts } from './context';
import { CodeMirrorEditor } from './types';
export declare type TabState = {
    id: string;
    hash: string;
    title: string;
    query: string | null;
    variables: string | null;
    headers: string | null;
    operationName: string | null;
    response: string | null;
};
export declare type TabsState = {
    tabs: TabState[];
    activeTabIndex: number;
};
export declare function getDefaultTabState({ headers, query, variables, storage, }: {
    headers: string | null;
    query: string | null;
    variables: string | null;
    storage: StorageAPI | null;
}): TabsState;
export declare function useSynchronizeActiveTabValues({ queryEditor, variableEditor, headerEditor, responseEditor, }: {
    queryEditor: CodeMirrorEditorWithOperationFacts | null;
    variableEditor: CodeMirrorEditor | null;
    headerEditor: CodeMirrorEditor | null;
    responseEditor: CodeMirrorEditor | null;
}): (state: TabsState) => TabsState;
export declare function useStoreTabs({ storage, shouldPersistHeaders, }: {
    storage: StorageAPI | null;
    shouldPersistHeaders?: boolean;
}): (currentState: TabsState) => void;
export declare function useSetEditorValues({ queryEditor, variableEditor, headerEditor, responseEditor, }: {
    queryEditor: CodeMirrorEditorWithOperationFacts | null;
    variableEditor: CodeMirrorEditor | null;
    headerEditor: CodeMirrorEditor | null;
    responseEditor: CodeMirrorEditor | null;
}): ({ query, variables, headers, response, }: {
    query: string | null;
    variables: string | null;
    headers: string | null;
    response: string | null;
}) => void;
export declare function emptyTab(): TabState;
export declare function setPropertiesInActiveTab(state: TabsState, partialTab: Partial<Omit<TabState, 'id' | 'hash' | 'title'>>): TabsState;
export declare function fuzzyExtractOperationName(str: string): string | null;
