import { Fetcher, Unsubscribable } from '@graphiql/toolkit';
import { FragmentDefinitionNode } from 'graphql';
import { ReactNode } from 'react';
import { EditCallback } from './editor/hooks';
export declare type ExecutionContextType = {
    isFetching: boolean;
    run(selectedOperationName?: string): void;
    stop(): void;
    subscription: Unsubscribable | null;
};
export declare const ExecutionContext: import("react").Context<ExecutionContextType | null>;
declare type ExecutionContextProviderProps = {
    children: ReactNode;
    externalFragments?: FragmentDefinitionNode[] | string;
    fetcher: Fetcher;
    onEditOperationName?: EditCallback;
    shouldPersistHeaders?: boolean;
};
export declare function ExecutionContextProvider(props: ExecutionContextProviderProps): JSX.Element;
export declare const useExecutionContext: {
    (options: {
        nonNull: true;
        caller?: Function | undefined;
    }): ExecutionContextType;
    (options: {
        nonNull?: boolean | undefined;
        caller?: Function | undefined;
    }): ExecutionContextType | null;
    (): ExecutionContextType | null;
};
export {};
