import { Fetcher } from '@graphiql/toolkit';
import { GraphQLError, GraphQLSchema } from 'graphql';
import { Dispatch, ReactNode, SetStateAction } from 'react';
/**
 * There's a semantic difference between `null` and `undefined`:
 * - When `null` is passed explicitly as prop, GraphiQL will run schemaless
 *   (i.e. it will never attempt to fetch the schema, even when calling the
 *   `useFetchSchema` hook).
 * - When `schema` is `undefined` GraphiQL will attempt to fetch the schema
 *   when calling `useFetchSchema`.
 */
declare type MaybeGraphQLSchema = GraphQLSchema | null | undefined;
export declare type SchemaContextType = {
    fetchError: string | null;
    isFetching: boolean;
    schema: MaybeGraphQLSchema;
    setFetchError: Dispatch<SetStateAction<string | null>>;
    setSchema: Dispatch<SetStateAction<MaybeGraphQLSchema>>;
    validationErrors: readonly GraphQLError[] | null;
};
export declare const SchemaContext: import("react").Context<SchemaContextType | null>;
declare type SchemaContextProviderProps = {
    children: ReactNode;
    dangerouslyAssumeSchemaIsValid?: boolean;
    fetcher: Fetcher;
    schema?: GraphQLSchema | null;
} & IntrospectionArgs;
export declare function SchemaContextProvider(props: SchemaContextProviderProps): JSX.Element;
export declare const useSchemaContext: {
    (options: {
        nonNull: true;
        caller?: Function | undefined;
    }): SchemaContextType;
    (options: {
        nonNull?: boolean | undefined;
        caller?: Function | undefined;
    }): SchemaContextType | null;
    (): SchemaContextType | null;
};
declare type IntrospectionArgs = {
    inputValueDeprecation?: boolean;
    introspectionQueryName?: string;
    schemaDescription?: boolean;
};
export {};
