import { DocumentNode, OperationDefinitionNode } from 'graphql';
import { VariableToType } from 'graphql-language-service';
import { ReactNode } from 'react';
import { TabsState, TabState } from './tabs';
import { CodeMirrorEditor } from './types';
export declare type CodeMirrorEditorWithOperationFacts = CodeMirrorEditor & {
    documentAST: DocumentNode | null;
    operationName: string | null;
    operations: OperationDefinitionNode[] | null;
    variableToType: VariableToType | null;
};
export declare type EditorContextType = {
    activeTabIndex: number;
    tabs: TabState[];
    addTab(): void;
    changeTab(index: number): void;
    closeTab(index: number): void;
    updateActiveTabValues(partialTab: Partial<Omit<TabState, 'id' | 'hash' | 'title'>>): void;
    headerEditor: CodeMirrorEditor | null;
    queryEditor: CodeMirrorEditorWithOperationFacts | null;
    responseEditor: CodeMirrorEditor | null;
    variableEditor: CodeMirrorEditor | null;
    setHeaderEditor(newEditor: CodeMirrorEditor): void;
    setQueryEditor(newEditor: CodeMirrorEditorWithOperationFacts): void;
    setResponseEditor(newEditor: CodeMirrorEditor): void;
    setVariableEditor(newEditor: CodeMirrorEditor): void;
    initialHeaders: string;
    initialQuery: string;
    initialVariables: string;
};
export declare const EditorContext: import("react").Context<EditorContextType | null>;
declare type EditorContextProviderProps = {
    children: ReactNode;
    defaultQuery?: string;
    headers?: string;
    onTabChange?(tabs: TabsState): void;
    query?: string;
    shouldPersistHeaders?: boolean;
    variables?: string;
};
export declare function EditorContextProvider(props: EditorContextProviderProps): JSX.Element;
export declare const useEditorContext: {
    (options: {
        nonNull: true;
        caller?: Function | undefined;
    }): EditorContextType;
    (options: {
        nonNull?: boolean | undefined;
        caller?: Function | undefined;
    }): EditorContextType | null;
    (): EditorContextType | null;
};
export {};
