/// <reference types="react" />
import type { SchemaReference } from 'codemirror-graphql/utils/SchemaReference';
import type { DocumentNode, FragmentDefinitionNode, ValidationRule } from 'graphql';
import { CopyQueryCallback, EditCallback } from './hooks';
import { KeyMap } from './types';
declare type OnClickReference = (reference: SchemaReference) => void;
export declare type UseQueryEditorArgs = {
    editorTheme?: string;
    externalFragments?: string | FragmentDefinitionNode[];
    onClickReference?: OnClickReference;
    onCopyQuery?: CopyQueryCallback;
    onEdit?(value: string, documentAST?: DocumentNode): void;
    onEditOperationName?: EditCallback;
    readOnly?: boolean;
    validationRules?: ValidationRule[];
    keyMap?: KeyMap;
};
export declare function useQueryEditor({ editorTheme, keyMap, externalFragments, onClickReference, onCopyQuery, onEdit, onEditOperationName, readOnly, validationRules, }?: UseQueryEditorArgs): import("react").RefObject<HTMLDivElement>;
export declare const STORAGE_KEY_QUERY = "query";
export {};
